/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves;

import com.flanks255.simplygraves.GraveBlock;
import com.flanks255.simplygraves.GraveData;
import com.flanks255.simplygraves.GraveEntity;
import com.flanks255.simplygraves.PlayerPreferences;
import com.flanks255.simplygraves.SGBlocks;
import com.flanks255.simplygraves.SimplyGraves;
import com.flanks255.simplygraves.WSD.GraveStorage;
import com.flanks255.simplygraves.WSD.PreferenceStorage;
import com.flanks255.simplygraves.config.CommonConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.registries.DeferredBlock;

public class DropEvent {
    public static void Event(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.getEntity().level().isClientSide) {
                Collection drops;
                PlayerPreferences prefs = PreferenceStorage.get().getPrefs(player.getUUID());
                long time = System.currentTimeMillis();
                if (!prefs.getGraveOption().orElse((Boolean)CommonConfig.DEFAULT_GRAVE_OPTION.get()).booleanValue()) {
                    return;
                }
                if (time - prefs.getLastGrave() < (long)((Integer)CommonConfig.GRAVE_COOLDOWN.get() * 1000)) {
                    Duration timeLeft = Duration.ofSeconds((long)((Integer)CommonConfig.GRAVE_COOLDOWN.get()).intValue() - (time - prefs.getLastGrave()) / 1000L);
                    player.sendSystemMessage((Component)Component.translatable((String)"simplygraves.cooldown", (Object[])new Object[]{timeLeft.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase()}).withStyle(style -> style.withColor(ChatFormatting.RED)));
                    return;
                }
                if (prefs.getGraveOption().isEmpty()) {
                    player.sendSystemMessage((Component)Component.translatable((String)((Boolean)CommonConfig.DEFAULT_GRAVE_OPTION.get() != false ? "simplygraves.server_enabled" : "simplygraves.server_disabled")));
                    player.sendSystemMessage((Component)Component.translatable((String)"simplygraves.server_choice"));
                    MutableComponent optInLink = Component.literal((String)"Opt-in");
                    optInLink.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/sg option enable")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Enable Graves"))).withColor(ChatFormatting.GREEN).withUnderlined(Boolean.valueOf(true)));
                    MutableComponent optOutLink = Component.literal((String)"Opt-out");
                    optOutLink.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/sg option disable")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Disable Graves"))).withColor(ChatFormatting.GREEN).withUnderlined(Boolean.valueOf(true)));
                    player.sendSystemMessage((Component)Component.literal((String)"[").append((Component)optInLink).append("] - [").append((Component)optOutLink).append("]"));
                }
                if ((drops = event.getDrops()).isEmpty()) {
                    return;
                }
                ItemStackHandler inventory = new ItemStackHandler(drops.size());
                ArrayList toRemove = new ArrayList();
                drops.forEach(drop -> {
                    if (!drop.getItem().is(SimplyGraves.NO_GRAVE)) {
                        ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)drop.getItem(), (boolean)false);
                        toRemove.add(drop);
                    }
                });
                toRemove.forEach(drops::remove);
                UUID uuid = UUID.randomUUID();
                BlockPos pos = player.getOnPos().above();
                String name = player.getName().getString();
                GraveStorage.get().addGrave(uuid, new GraveData(player.getUUID(), name, uuid, pos, (ResourceKey<Level>)player.level().dimension(), time, inventory, false));
                Level level = player.level();
                BlockPos gravePos = DropEvent.search(level, pos);
                boolean replaceable = DropEvent.valid(level, gravePos);
                if (replaceable) {
                    DeferredBlock<GraveBlock> block = SGBlocks.GRAVES.get(event.getEntity().level().random.nextInt(SGBlocks.GRAVES.size()));
                    BlockState state = ((GraveBlock)((Object)block.get())).defaultBlockState();
                    if (level.setBlock(gravePos, state, 3)) {
                        BlockEntity blockEntity;
                        if (level.getBlockState(gravePos).hasBlockEntity() && (blockEntity = level.getBlockEntity(gravePos)) instanceof GraveEntity) {
                            GraveEntity entity = (GraveEntity)blockEntity;
                            SimplyGraves.LOGGER.info("Grave placed @ " + gravePos);
                            DropEvent.successGrave(player, uuid, gravePos, level.dimension().location().getPath());
                            entity.setGrave(uuid, player.getUUID(), name, time);
                        } else {
                            DropEvent.failedGrave(player, uuid);
                        }
                    } else {
                        DropEvent.failedGrave(player, uuid);
                    }
                } else {
                    DropEvent.failedGrave(player, uuid);
                }
                prefs.setLastGrave(time);
            }
        }
    }

    private static void successGrave(Player player, UUID graveUUID, BlockPos pos, String dim) {
        player.sendSystemMessage((Component)Component.translatable((String)"simplygraves.success", (Object[])new Object[]{Component.literal((String)pos.toShortString()).withStyle(style -> style.withColor(ChatFormatting.GREEN)), Component.literal((String)dim).withStyle(style -> style.withColor(ChatFormatting.GREEN)), Component.literal((String)graveUUID.toString().substring(0, 8)).withStyle(style -> style.withColor(ChatFormatting.BLUE))}));
    }

    private static void failedGrave(Player player, UUID graveUUID) {
        SimplyGraves.LOGGER.info("Grave for " + player.getName().getString() + " failed to place.");
        GraveStorage.get().setFailed(graveUUID);
        MutableComponent recover = Component.literal((String)"Recover");
        recover.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/sg failed")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Recover failed grave"))).withColor(ChatFormatting.GREEN).withUnderlined(Boolean.valueOf(true)));
        player.sendSystemMessage((Component)Component.translatable((String)"simplygraves.failed"));
        player.sendSystemMessage((Component)Component.literal((String)"    [").append((Component)recover).append("]"));
    }

    private static boolean valid(Level level, BlockPos pos) {
        return level.getBlockState(pos).canBeReplaced();
    }

    private static BlockHitResult checkColumn(Level level, BlockPos pos) {
        Vec3 start = Vec3.atCenterOf((Vec3i)pos.above(4));
        Vec3 end = Vec3.atCenterOf((Vec3i)pos);
        return level.clip(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, CollisionContext.empty()));
    }

    private static BlockPos search(Level level, BlockPos deathPos) {
        if (DropEvent.valid(level, deathPos)) {
            return deathPos;
        }
        if (DropEvent.valid(level, deathPos.above())) {
            return deathPos.above();
        }
        BlockHitResult res1 = DropEvent.checkColumn(level, deathPos);
        if (res1.getType() == HitResult.Type.BLOCK && DropEvent.valid(level, res1.getBlockPos().above())) {
            return res1.getBlockPos().above();
        }
        BlockHitResult res2 = DropEvent.checkColumn(level, deathPos.north());
        if (res2.getType() == HitResult.Type.BLOCK && DropEvent.valid(level, res2.getBlockPos().above())) {
            return res2.getBlockPos().above();
        }
        BlockHitResult res3 = DropEvent.checkColumn(level, deathPos.south());
        if (res3.getType() == HitResult.Type.BLOCK && DropEvent.valid(level, res3.getBlockPos().above())) {
            return res3.getBlockPos().above();
        }
        BlockHitResult res4 = DropEvent.checkColumn(level, deathPos.east());
        if (res4.getType() == HitResult.Type.BLOCK && DropEvent.valid(level, res4.getBlockPos().above())) {
            return res4.getBlockPos().above();
        }
        BlockHitResult res5 = DropEvent.checkColumn(level, deathPos.west());
        if (res5.getType() == HitResult.Type.BLOCK && DropEvent.valid(level, res5.getBlockPos().above())) {
            return res5.getBlockPos().above();
        }
        return deathPos;
    }
}

