/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves;

import com.flanks255.simplygraves.Grave;
import com.flanks255.simplygraves.GraveEntity;
import com.flanks255.simplygraves.WSD.GraveStorage;
import com.flanks255.simplygraves.config.CommonConfig;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraveBlock
extends Block
implements EntityBlock {
    public final Grave graveType;

    public GraveBlock(Grave graveIn) {
        super(BlockBehaviour.Properties.of().forceSolidOn().strength(200.0f, 3600000.0f).pushReaction(PushReaction.BLOCK));
        this.graveType = graveIn;
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pPos, @Nonnull BlockState pState) {
        return new GraveEntity(pPos, pState);
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState pState, @Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull CollisionContext pContext) {
        return this.graveType.shape;
    }

    @NotNull
    public InteractionResult use(@Nonnull BlockState pState, Level pLevel, @Nonnull BlockPos pPos, @Nonnull Player pPlayer, @Nonnull InteractionHand pHand, @Nonnull BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (!pLevel.isClientSide() && !pPlayer.isCrouching() && pHand == InteractionHand.MAIN_HAND && pLevel.getBlockState(pPos).hasBlockEntity() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof GraveEntity) {
            GraveEntity entity = (GraveEntity)blockEntity;
            UUID playerUUID = pPlayer.getUUID();
            entity.getUUID().ifPresent(uuid -> {
                GraveStorage storage = GraveStorage.get();
                if (storage.getGrave((UUID)uuid).isEmpty()) {
                    storage.removeGrave((UUID)uuid);
                    pLevel.removeBlockEntity(pPos);
                    pLevel.removeBlock(pPos, false);
                    pLevel.levelEvent(2001, pPos, Block.getId((BlockState)pState));
                }
                storage.getGrave((UUID)uuid).ifPresent(graveData -> {
                    if (!playerUUID.equals(graveData.playerUUID) && graveData.deathTime + (long)((Integer)CommonConfig.DELAY_TO_PUBLIC.get() * 1000) > System.currentTimeMillis()) {
                        pPlayer.sendSystemMessage((Component)Component.translatable((String)"simplygraves.not_yours", (Object[])new Object[]{graveData.playerName}));
                        return;
                    }
                    ItemStackHandler inv = graveData.inventory;
                    for (int i = 0; i < inv.getSlots(); ++i) {
                        ItemStack stack = inv.getStackInSlot(i);
                        if (stack.isEmpty()) continue;
                        ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)stack);
                    }
                    storage.removeGrave((UUID)uuid);
                    pLevel.removeBlockEntity(pPos);
                    pLevel.removeBlock(pPos, false);
                    pLevel.levelEvent(2001, pPos, Block.getId((BlockState)pState));
                });
            });
        }
        return super.use(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
    }
}

