/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves;

import com.flanks255.simplygraves.SGBlocks;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class GraveEntity
extends BlockEntity {
    private UUID uuid = Util.NIL_UUID;
    private UUID player = Util.NIL_UUID;
    private String playerName = "";
    private long deathTime = 0L;

    public GraveEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(SGBlocks.GRAVE_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getPlayer() {
        return this.player;
    }

    public long getDeathTime() {
        return this.deathTime;
    }

    public void setGrave(UUID pUUID, UUID playerUUID, String pPlayerName, long pDeathTime) {
        this.uuid = pUUID;
        this.playerName = pPlayerName;
        this.deathTime = pDeathTime;
        this.player = playerUUID;
    }

    public Optional<UUID> getUUID() {
        if (this.uuid == Util.NIL_UUID || this.uuid == null) {
            return Optional.empty();
        }
        return Optional.of(this.uuid);
    }

    @NotNull
    public CompoundTag getUpdateTag() {
        CompoundTag tag = super.getUpdateTag();
        tag.putUUID("UUID", this.uuid);
        tag.putUUID("playerUUID", this.player);
        tag.putString("PlayerName", this.playerName);
        tag.putLong("DeathTime", this.deathTime);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.uuid = tag.getUUID("UUID");
        this.player = tag.getUUID("playerUUID");
        this.playerName = tag.getString("PlayerName");
        this.deathTime = tag.getLong("DeathTime");
    }

    public void load(@NotNull CompoundTag pTag) {
        super.load(pTag);
        this.uuid = pTag.getUUID("UUID");
        this.player = pTag.getUUID("playerUUID");
        this.playerName = pTag.getString("PlayerName");
        this.deathTime = pTag.getLong("DeathTime");
    }

    protected void saveAdditional(@NotNull CompoundTag pTag) {
        super.saveAdditional(pTag);
        pTag.putUUID("UUID", this.uuid);
        pTag.putUUID("playerUUID", this.player);
        pTag.putString("PlayerName", this.playerName);
        pTag.putLong("DeathTime", this.deathTime);
    }
}

