/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves;

import com.flanks255.simplygraves.DropEvent;
import com.flanks255.simplygraves.SGBlocks;
import com.flanks255.simplygraves.WSD.GraveStorage;
import com.flanks255.simplygraves.commands.SGCommands;
import com.flanks255.simplygraves.config.CommonConfig;
import com.flanks255.simplygraves.data.Generator;
import com.flanks255.simplygraves.render.EntityRenders;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="simplygraves")
public class SimplyGraves {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "simplygraves";
    public static final TagKey<Item> NO_GRAVE = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation("simplygraves", "no_grave"));
    public static final TagKey<Block> FTBCHUNKS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("ftbchunks", "interact_whitelist"));
    public static final TagKey<Block> CADMUS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("cadmus", "allows_claim_interaction"));
    public static final TagKey<Block> GAIA_BLOCK = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("botania", "gaia_break_blacklist"));
    public static final TagKey<Block> GRAVES = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("simplygraves", "graves"));
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"simplygraves");

    public SimplyGraves(IEventBus bus) {
        SGBlocks.init(bus);
        ITEMS.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.COMMON_CONFIG);
        bus.addListener(this::setup);
        bus.addListener(Generator::gatherData);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            bus.addListener(EntityRenders::registerEntityRenderers);
        }
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, DropEvent::Event);
        NeoForge.EVENT_BUS.addListener(this::commandsRegister);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void commandsRegister(RegisterCommandsEvent event) {
        SGCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static Set<String> getUUIDSuggestions() {
        GraveStorage graveStorage = GraveStorage.get();
        HashSet<String> list = new HashSet<String>();
        graveStorage.getData().forEach((uuid, graveData) -> list.add(uuid.toString()));
        if (list.isEmpty()) {
            list.add("[No graves]");
        }
        return list;
    }
}

