/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves.WSD;

import com.flanks255.simplygraves.GraveData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class GraveStorage
extends SavedData {
    private static final String NAME = "simplygraves_data";
    private static final HashMap<UUID, GraveData> data = new HashMap();
    private static GraveStorage INSTANCE = null;

    public CompoundTag save(CompoundTag pCompoundTag) {
        ListTag list = new ListTag();
        data.forEach((uuid, grave) -> list.add((Object)grave.serializeNBT()));
        pCompoundTag.put("Graves", (Tag)list);
        return pCompoundTag;
    }

    public static GraveStorage load(CompoundTag pCompoundTag) {
        if (pCompoundTag.contains("Graves")) {
            ListTag list = pCompoundTag.getList("Graves", 10);
            list.forEach(tag -> {
                CompoundTag graveTag = (CompoundTag)tag;
                data.put(graveTag.getUUID("GraveUUID"), GraveData.deserializeNBT(graveTag));
            });
        }
        return new GraveStorage();
    }

    public static GraveStorage get() {
        if (INSTANCE == null) {
            INSTANCE = (GraveStorage)ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(GraveStorage::new, GraveStorage::load), NAME);
        }
        return INSTANCE;
    }

    public HashMap<UUID, GraveData> getData() {
        return data;
    }

    public void addGrave(UUID uuid, GraveData grave) {
        data.put(uuid, grave);
        this.setDirty();
    }

    public void removeGrave(UUID uuid) {
        data.remove(uuid);
        this.setDirty();
    }

    public Optional<GraveData> getGrave(UUID uuid) {
        if (data.containsKey(uuid)) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public Optional<GraveData> getLastGrave(ServerPlayer player) {
        return data.values().stream().filter(g -> g.playerUUID.compareTo(player.getUUID()) == 0).sorted().findFirst();
    }

    public Optional<GraveData> getFailedGrave(ServerPlayer player) {
        for (Map.Entry<UUID, GraveData> entry : data.entrySet()) {
            if (!entry.getValue().failed || entry.getValue().playerUUID.compareTo(player.getUUID()) != 0) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public void setFailed(UUID uuid) {
        GraveStorage.data.get((Object)uuid).failed = true;
        this.setDirty();
    }
}

