/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves.WSD;

import com.flanks255.simplygraves.PlayerPreferences;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class PreferenceStorage
extends SavedData {
    private static final String NAME = "simplygraves_prefs";
    private static final HashMap<UUID, PlayerPreferences> data = new HashMap();
    private static PreferenceStorage INSTANCE = null;

    public CompoundTag save(CompoundTag pCompoundTag) {
        ListTag list = new ListTag();
        data.forEach((uuid, pref) -> list.add((Object)pref.save()));
        pCompoundTag.put("Prefs", (Tag)list);
        return pCompoundTag;
    }

    public static PreferenceStorage load(CompoundTag nbt) {
        if (nbt.contains("Prefs")) {
            ListTag list = nbt.getList("Prefs", 10);
            list.forEach(tag -> {
                CompoundTag prefTag = (CompoundTag)tag;
                data.put(prefTag.getUUID("uuid"), PlayerPreferences.of(prefTag));
            });
        }
        return new PreferenceStorage();
    }

    public static PreferenceStorage get() {
        if (INSTANCE == null) {
            INSTANCE = (PreferenceStorage)ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(PreferenceStorage::new, PreferenceStorage::load), NAME);
        }
        return INSTANCE;
    }

    public PlayerPreferences getPrefs(UUID player) {
        return data.computeIfAbsent(player, uuid -> {
            this.setDirty();
            return new PlayerPreferences((UUID)uuid);
        });
    }
}

