/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves.commands;

import com.flanks255.simplygraves.GraveData;
import com.flanks255.simplygraves.WSD.GraveStorage;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class List {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(cs -> cs.hasPermission(1))).executes(cs -> List.list((CommandContext<CommandSourceStack>)cs, ""))).then(Commands.argument((String)"PlayerName", (ArgumentType)StringArgumentType.string()).suggests((cs, builder) -> SharedSuggestionProvider.suggest(List.getPlayerSuggestions((CommandContext<CommandSourceStack>)cs), (SuggestionsBuilder)builder)).executes(cs -> List.list((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"PlayerName"))));
    }

    public static Set<String> getPlayerSuggestions(CommandContext<CommandSourceStack> commandSource) {
        HashSet<String> list = new HashSet<String>();
        ((CommandSourceStack)commandSource.getSource()).getServer().getPlayerList().getPlayers().forEach(serverPlayerEntity -> list.add(serverPlayerEntity.getName().getString()));
        return list;
    }

    public static int list(CommandContext<CommandSourceStack> ctx, String playername) {
        GraveStorage storage = GraveStorage.get();
        HashMap<UUID, GraveData> data = storage.getData();
        if (data.size() == 0) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"[ ]"), false);
            return 0;
        }
        if (Objects.equals(playername, "")) {
            data.forEach((uuid, grave) -> List.sendGrave((Player)((CommandSourceStack)ctx.getSource()).getPlayer(), grave));
        } else {
            data.forEach((uuid, grave) -> {
                if (grave.playerName.equalsIgnoreCase(playername)) {
                    List.sendGrave((Player)((CommandSourceStack)ctx.getSource()).getPlayer(), grave);
                }
            });
        }
        return 0;
    }

    public static void sendGrave(Player player, GraveData graveData) {
        player.sendSystemMessage((Component)Component.literal((String)"===========================").withStyle(ChatFormatting.DARK_GRAY));
        player.sendSystemMessage((Component)Component.literal((String)(graveData.graveUUID.toString().substring(0, 8) + "...\n" + graveData.playerName + "\n" + SDF.format(new Date(graveData.deathTime)))));
    }
}

