/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves.commands;

import com.flanks255.simplygraves.SimplyGraves;
import com.flanks255.simplygraves.WSD.GraveStorage;
import com.flanks255.simplygraves.commands.List;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class Recover {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"recover").requires(cs -> cs.hasPermission(1))).then(Commands.argument((String)"UUID", (ArgumentType)UuidArgument.uuid()).suggests((context, builder) -> SharedSuggestionProvider.suggest(SimplyGraves.getUUIDSuggestions(), (SuggestionsBuilder)builder)).then(Commands.argument((String)"Player", (ArgumentType)EntityArgument.player()).suggests((cs, builder) -> SharedSuggestionProvider.suggest(List.getPlayerSuggestions((CommandContext<CommandSourceStack>)cs), (SuggestionsBuilder)builder)).executes(cs -> Recover.recover((CommandContext<CommandSourceStack>)cs, UuidArgument.getUuid((CommandContext)cs, (String)"UUID"), (Player)EntityArgument.getPlayer((CommandContext)cs, (String)"Player")))));
    }

    public static int recover(CommandContext<CommandSourceStack> ctx, UUID uuid, Player target) throws CommandSyntaxException {
        GraveStorage storage = GraveStorage.get();
        storage.getGrave(uuid).ifPresent(grave -> {
            ItemStackHandler inv = grave.inventory;
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemHandlerHelper.giveItemToPlayer((Player)target, (ItemStack)inv.getStackInSlot(i));
            }
            storage.removeGrave(uuid);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Grave recovered to ").append(target.getDisplayName()), false);
        });
        return 0;
    }
}

