/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplygraves.render;

import com.flanks255.simplygraves.GraveEntity;
import com.flanks255.simplygraves.config.CommonConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.text.SimpleDateFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class GraveTextRender
implements BlockEntityRenderer<GraveEntity> {
    private static final SimpleDateFormat format = new SimpleDateFormat("mm:ss");

    public void render(@Nonnull GraveEntity graveEntity, float pPartialTick, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        matrixStack.scale(1.0f, -1.0f, 1.0f);
        matrixStack.scale(0.03f, 0.03f, 0.03f);
        Vec3 cameraPos = Minecraft.getInstance().getEntityRenderDispatcher().camera.getPosition();
        BlockPos gravePos = graveEntity.getBlockPos();
        boolean isMine = graveEntity.getPlayer().compareTo(Minecraft.getInstance().player.getUUID()) == 0;
        double angle = Mth.atan2((double)(cameraPos.z - (double)((float)gravePos.getZ() + 0.5f)), (double)(cameraPos.x - (double)((float)gravePos.getX() + 0.5f)));
        matrixStack.mulPose(Axis.YP.rotation((float)(1.5707963267948966 - (double)((float)angle))));
        Font font = Minecraft.getInstance().font;
        this.drawCenteredString(matrixStack, font, graveEntity.getPlayerName(), 0, -25, 0xFFFFFF, pBufferSource);
        long timeRemaining = 0L;
        if (!isMine && (timeRemaining = graveEntity.getDeathTime() + (long)((Integer)CommonConfig.DELAY_TO_PUBLIC.get() * 1000) - System.currentTimeMillis()) > 0L) {
            matrixStack.translate(0.0f, -15.0f, 0.0f);
            matrixStack.scale(0.25f, 0.25f, 0.25f);
            this.drawCenteredString(matrixStack, font, format.format(timeRemaining), 0, 0, 0xFFFF00, pBufferSource);
        }
        if (isMine || timeRemaining == 0L) {
            matrixStack.translate(0.0f, -15.0f, 0.0f);
            matrixStack.scale(0.25f, 0.25f, 0.25f);
            this.drawCenteredString(matrixStack, font, "Right-click to collect.", 0, 0, 0xFFFFFF, pBufferSource);
        }
        matrixStack.popPose();
    }

    private void drawCenteredString(PoseStack matrixStack, Font font, String string, int x, int y, int color, @NotNull MultiBufferSource pBufferSource) {
        float offset = (float)(-font.width(string)) / 2.0f;
        font.drawInBatch(string, (float)x + offset, (float)y, color, false, matrixStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public int getViewDistance() {
        return 10;
    }
}

