/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts;

import com.illusivesoulworks.comforts.ComfortsCommonMod;
import com.illusivesoulworks.comforts.ComfortsConstants;
import com.illusivesoulworks.comforts.ComfortsNeoForgeClientMod;
import com.illusivesoulworks.comforts.common.ComfortsCommonEventsListener;
import com.illusivesoulworks.comforts.common.ComfortsRegistry;
import com.illusivesoulworks.comforts.common.SleepDataAttachment;
import com.illusivesoulworks.comforts.common.capability.ISleepData;
import com.illusivesoulworks.comforts.common.network.ComfortsClientPayloadHandler;
import com.illusivesoulworks.comforts.common.network.SPacketAutoSleep;
import com.illusivesoulworks.comforts.common.network.SPacketPlaceBag;
import com.illusivesoulworks.comforts.common.registry.RegistryObject;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="comforts")
public class ComfortsNeoForgeMod {
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"comforts");
    public static final Supplier<AttachmentType<? extends ISleepData>> SLEEP_DATA = ATTACHMENT_TYPES.register("sleep_data", () -> AttachmentType.serializable(SleepDataAttachment::new).copyOnDeath().build());

    public ComfortsNeoForgeMod(IEventBus eventBus) {
        ComfortsCommonMod.init();
        ComfortsCommonMod.initConfig();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ComfortsNeoForgeClientMod.init(eventBus);
        }
        ATTACHMENT_TYPES.register(eventBus);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::registerPayloadHandler);
        eventBus.addListener(this::creativeTab);
    }

    private void setup(FMLCommonSetupEvent evt) {
        NeoForge.EVENT_BUS.register((Object)new ComfortsCommonEventsListener());
    }

    private void registerPayloadHandler(RegisterPayloadHandlerEvent evt) {
        evt.registrar("comforts").play(SPacketAutoSleep.ID, SPacketAutoSleep::new, handler -> handler.client(ComfortsClientPayloadHandler.getInstance()::handleAutoSleep));
        evt.registrar("comforts").play(SPacketPlaceBag.ID, SPacketPlaceBag::new, handler -> handler.client(ComfortsClientPayloadHandler.getInstance()::handlePlaceBag));
    }

    private void creativeTab(BuildCreativeModeTabContentsEvent evt) {
        ResourceKey tab = evt.getTabKey();
        if (tab == CreativeModeTabs.COLORED_BLOCKS || tab == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            for (RegistryObject<Block> value : ComfortsRegistry.SLEEPING_BAGS.values()) {
                evt.accept((ItemLike)value.get());
                ComfortsConstants.LOG.info(value.getResourceKey().toString());
            }
            for (RegistryObject<Block> value : ComfortsRegistry.HAMMOCKS.values()) {
                evt.accept((ItemLike)value.get());
            }
        }
        if (tab == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            evt.accept((ItemLike)ComfortsRegistry.ROPE_AND_NAIL_ITEM.get());
        }
    }
}

