/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common.block;

import com.illusivesoulworks.comforts.common.ComfortsConfig;
import com.illusivesoulworks.comforts.common.block.entity.BaseComfortsBlockEntity;
import com.illusivesoulworks.comforts.mixin.AccessorPlayer;
import com.illusivesoulworks.comforts.platform.Services;
import com.mojang.datafixers.util.Either;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class BaseComfortsBlock
extends BedBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final BedType type;

    public BaseComfortsBlock(BedType type, DyeColor colorIn, BlockBehaviour.Properties properties) {
        super(colorIn, properties);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PART, (Comparable)BedPart.FOOT)).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static Direction getDirectionToOther(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.getOpposite();
    }

    @Nonnull
    public InteractionResult use(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (state.getValue((Property)PART) != BedPart.HEAD && !(state = level.getBlockState(pos = pos.relative((Direction)state.getValue((Property)FACING)))).is((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!BaseComfortsBlock.canSetSpawn((Level)level)) {
            level.removeBlock(pos, false);
            BlockPos blockpos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
            if (level.getBlockState(blockpos).is((Block)this)) {
                level.removeBlock(blockpos, false);
            }
            Vec3 vec3 = pos.getCenter();
            level.explode(null, level.damageSources().badRespawnPointExplosion(vec3), null, vec3, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)OCCUPIED)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(level, pos)) {
                player.displayClientMessage((Component)Component.translatable((String)("block.comforts." + this.type.name + ".occupied")), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BaseComfortsBlock.trySleep(serverPlayer, pos, false).ifLeft(result -> {
                if (result != null) {
                    Component text;
                    switch (result) {
                        case NOT_POSSIBLE_NOW: {
                            Component message = ComfortsConfig.ComfortsTimeUse.NIGHT.getMessage();
                            if (this.type == BedType.HAMMOCK) {
                                message = ((ComfortsConfig.ComfortsTimeUse)((Object)((Object)ComfortsConfig.SERVER.hammockUse.get()))).getMessage();
                            } else if (this.type == BedType.SLEEPING_BAG) {
                                message = ((ComfortsConfig.ComfortsTimeUse)((Object)((Object)ComfortsConfig.SERVER.sleepingBagUse.get()))).getMessage();
                            }
                            Component component = message;
                            break;
                        }
                        case TOO_FAR_AWAY: {
                            Component component = Component.translatable((String)("block.comforts." + this.type.name + ".too_far_away"));
                            break;
                        }
                        default: {
                            Component component = text = result.getMessage();
                        }
                    }
                    if (text != null) {
                        player.displayClientMessage(text, true);
                    }
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    public static Either<Player.BedSleepingProblem, Unit> trySleep(ServerPlayer player, BlockPos at, boolean dryRun) {
        Player.BedSleepingProblem ret = Services.SLEEP_EVENTS.getSleepResult((Player)player, at);
        if (ret != null) {
            return Either.left((Object)ret);
        }
        Direction direction = player.level().getBlockState(at).getOptionalValue((Property)HorizontalDirectionalBlock.FACING).orElse(player.getDirection());
        if (!player.isSleeping() && player.isAlive()) {
            if (!player.level().dimensionType().natural()) {
                return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_HERE);
            }
            if (!BaseComfortsBlock.bedInRange(player, at, direction)) {
                return Either.left((Object)Player.BedSleepingProblem.TOO_FAR_AWAY);
            }
            if (BaseComfortsBlock.bedBlocked(player, at, direction)) {
                return Either.left((Object)Player.BedSleepingProblem.OBSTRUCTED);
            }
            if (Services.SLEEP_EVENTS.isAwakeTime((Player)player, at)) {
                return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
            }
            if (!player.isCreative()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3 vector3d = Vec3.atBottomCenterOf((Vec3i)at);
                List list = player.level().getEntitiesOfClass(Monster.class, new AABB(vector3d.x() - 8.0, vector3d.y() - 5.0, vector3d.z() - 8.0, vector3d.x() + 8.0, vector3d.y() + 5.0, vector3d.z() + 8.0), monster -> monster.isPreventingPlayerRest((Player)player));
                if (!list.isEmpty()) {
                    return Either.left((Object)Player.BedSleepingProblem.NOT_SAFE);
                }
            }
            if (!dryRun) {
                BaseComfortsBlock comfortsBlock;
                Block block = player.level().getBlockState(at).getBlock();
                if (block instanceof BaseComfortsBlock && !(comfortsBlock = (BaseComfortsBlock)block).canRest()) {
                    int time = player.getStats().getValue(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST));
                    player.startSleeping(at);
                    player.getStats().setValue((Player)player, Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST), time);
                } else {
                    player.startSleeping(at);
                }
                ((AccessorPlayer)player).setSleepCounter(0);
                player.awardStat(Stats.SLEEP_IN_BED);
                CriteriaTriggers.SLEPT_IN_BED.trigger(player);
                ((ServerLevel)player.level()).updateSleepingPlayerList();
            }
            return Either.right((Object)Unit.INSTANCE);
        }
        return Either.left((Object)Player.BedSleepingProblem.OTHER_PROBLEM);
    }

    protected abstract boolean canRest();

    private static boolean bedInRange(ServerPlayer playerEntity, BlockPos blockPos, Direction direction) {
        if (direction == null) {
            return false;
        }
        return BaseComfortsBlock.isReachableBedBlock(playerEntity, blockPos) || BaseComfortsBlock.isReachableBedBlock(playerEntity, blockPos.relative(direction.getOpposite()));
    }

    private static boolean isReachableBedBlock(ServerPlayer playerEntity, BlockPos blockPos) {
        Vec3 vector3d = Vec3.atBottomCenterOf((Vec3i)blockPos);
        return Math.abs(playerEntity.getX() - vector3d.x()) <= 3.0 && Math.abs(playerEntity.getY() - vector3d.y()) <= 2.0 && Math.abs(playerEntity.getZ() - vector3d.z()) <= 3.0;
    }

    private static boolean bedBlocked(ServerPlayer playerEntity, BlockPos blockPos, Direction direction) {
        BlockPos blockpos = blockPos.above();
        return BaseComfortsBlock.isAbnormalCube(playerEntity.level(), blockpos) || BaseComfortsBlock.isAbnormalCube(playerEntity.level(), blockpos.relative(direction.getOpposite()));
    }

    private static boolean isAbnormalCube(Level world, BlockPos pos) {
        return world.getBlockState(pos).isSuffocating((BlockGetter)world, pos);
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos blockPos) {
        List list = level.getEntitiesOfClass(Villager.class, new AABB(blockPos), LivingEntity::isSleeping);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).stopSleeping();
        return true;
    }

    public BlockState playerWillDestroy(Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedpart;
        if (!level.isClientSide && player.isCreative() && (bedpart = (BedPart)state.getValue((Property)PART)) == BedPart.FOOT && (blockstate = level.getBlockState(blockpos = pos.relative(BaseComfortsBlock.getDirectionToOther(bedpart, (Direction)state.getValue((Property)FACING))))).getBlock() == this && blockstate.getValue((Property)PART) == BedPart.HEAD) {
            if (((Boolean)blockstate.getValue((Property)WATERLOGGED)).booleanValue()) {
                level.setBlock(blockpos, Blocks.WATER.defaultBlockState(), 35);
            } else {
                level.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
            }
            level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
        level.levelEvent(player, 2001, pos, BaseComfortsBlock.getId((BlockState)state));
        if (state.is(BlockTags.GUARDED_BY_PIGLINS)) {
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)false);
        }
        return state;
    }

    @Nonnull
    public BlockState updateShape(BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        BlockState state = super.getStateForPlacement(context);
        return state == null ? null : (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
        super.createBlockStateDefinition(builder);
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void setPlacedBy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity livingEntity, @Nonnull ItemStack stack) {
        super.setPlacedBy(level, pos, state, livingEntity, stack);
        BlockPos blockPos = pos.relative((Direction)state.getValue((Property)FACING));
        if (stack.hasCustomHoverName()) {
            level.getBlockEntity(blockPos, this.getBlockEntityType()).ifPresent(blockEntity -> blockEntity.setName(stack.getHoverName()));
        }
    }

    public abstract BlockEntityType<? extends BaseComfortsBlockEntity> getBlockEntityType();

    static enum BedType {
        HAMMOCK("hammock"),
        SLEEPING_BAG("sleeping_bag");

        private final String name;

        private BedType(String name) {
            this.name = name;
        }
    }
}

