/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common.item;

import com.illusivesoulworks.comforts.common.block.RopeAndNailBlock;
import com.illusivesoulworks.comforts.common.item.BaseComfortsItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class HammockItem
extends BaseComfortsItem {
    public HammockItem(Block block) {
        super(block);
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        if (state.getBlock() instanceof RopeAndNailBlock) {
            Direction direction = (Direction)state.getValue((Property)RopeAndNailBlock.HORIZONTAL_FACING);
            BlockPos blockpos = pos.relative(direction, 3);
            BlockState blockstate = level.getBlockState(blockpos);
            if (this.hasPartneredRopes(state, blockstate)) {
                InteractionResult result = this.place(BlockPlaceContext.at((BlockPlaceContext)new BlockPlaceContext(context), (BlockPos)context.getClickedPos().relative(direction), (Direction)direction));
                if (result.consumesAction()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)RopeAndNailBlock.SUPPORTING, (Comparable)Boolean.valueOf(true)));
                    level.setBlockAndUpdate(blockpos, (BlockState)blockstate.setValue((Property)RopeAndNailBlock.SUPPORTING, (Comparable)Boolean.valueOf(true)));
                } else if (player != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"block.comforts.hammock.no_space"), true);
                }
                return result;
            }
            if (player != null) {
                boolean flag = this.hasPartneredRopes(state, level.getBlockState(pos.relative(direction, 1)));
                boolean bl = flag = flag || this.hasPartneredRopes(state, level.getBlockState(pos.relative(direction, 2)));
                if (flag) {
                    player.displayClientMessage((Component)Component.translatable((String)"block.comforts.hammock.no_space"), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"block.comforts.hammock.missing_rope"), true);
                }
            }
        } else if (player != null) {
            player.displayClientMessage((Component)Component.translatable((String)"block.comforts.hammock.no_rope"), true);
        }
        return InteractionResult.FAIL;
    }

    private boolean hasPartneredRopes(BlockState state, BlockState otherState) {
        return otherState.getBlock() instanceof RopeAndNailBlock && otherState.getValue((Property)RopeAndNailBlock.HORIZONTAL_FACING) == ((Direction)state.getValue((Property)RopeAndNailBlock.HORIZONTAL_FACING)).getOpposite() && (Boolean)state.getValue((Property)RopeAndNailBlock.SUPPORTING) == false && (Boolean)otherState.getValue((Property)RopeAndNailBlock.SUPPORTING) == false;
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> components, @Nonnull TooltipFlag flag) {
        components.add((Component)Component.translatable((String)"item.comforts.hammock.placement.tooltip", (Object[])new Object[]{Component.translatable((String)"block.comforts.rope_and_nail").withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY));
    }
}

