/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler;

import com.leobeliik.extremesoundmuffler.Constants;
import com.leobeliik.extremesoundmuffler.NeoForgeConfig;
import com.leobeliik.extremesoundmuffler.SoundMufflerCommon;
import com.leobeliik.extremesoundmuffler.gui.buttons.InvButton;
import com.leobeliik.extremesoundmuffler.utils.DataManager;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="extremesoundmuffler")
public class SoundMufflerNeoForge {
    public SoundMufflerNeoForge(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "", (a, b) -> true));
        NeoForgeConfig.init();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        if (Constants.soundMufflerKey.consumeClick()) {
            SoundMufflerCommon.openMainScreen();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlayerJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        DataManager.loadData();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onMouseRelease(ScreenEvent.MouseButtonReleased.Post event) {
        if (event.getButton() == 1) {
            Screen screen = event.getScreen();
            for (GuiEventListener widget : screen.children()) {
                InvButton btn;
                if (!(widget instanceof InvButton) || !(btn = (InvButton)widget).isHovered()) continue;
                if (screen instanceof CreativeModeInventoryScreen) {
                    NeoForgeConfig.setCreativeInvButtonHorizontal(btn.getX());
                    NeoForgeConfig.setCreativeInvButtonVertical(btn.getY());
                    break;
                }
                NeoForgeConfig.setInvButtonHorizontal(btn.getX());
                NeoForgeConfig.setInvButtonVertical(btn.getY());
                break;
            }
        }
    }

    @Mod.EventBusSubscriber(modid="extremesoundmuffler", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public class ClientModListener {
        @SubscribeEvent
        public static void keyRegistry(RegisterKeyMappingsEvent event) {
            event.register(Constants.soundMufflerKey);
        }
    }
}

