/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.gui.buttons;

import com.leobeliik.extremesoundmuffler.CommonConfig;
import com.leobeliik.extremesoundmuffler.SoundMufflerCommon;
import com.leobeliik.extremesoundmuffler.gui.MufflerScreen;
import com.leobeliik.extremesoundmuffler.gui.buttons.PlaySoundButton;
import com.leobeliik.extremesoundmuffler.interfaces.IColorsGui;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class MuffledSlider
extends AbstractWidget
implements ISoundLists,
IColorsGui {
    private static final Minecraft minecraft = Minecraft.getInstance();
    private static boolean showSlider = false;
    private final Font font;
    private final ResourceLocation sound;
    private final MufflerScreen screen;
    private final int bg;
    private double sliderValue;
    private boolean isMuffling;
    private Button btnToggleSound;
    private PlaySoundButton btnPlaySound;

    public MuffledSlider(int x, int y, int bg, ResourceLocation sound, double sliderValue, MufflerScreen screen) {
        super(x, y, 205, 14, Component.nullToEmpty((String)(sound.getPath() + ":" + sound.getNamespace())));
        this.font = MuffledSlider.minecraft.font;
        this.isMuffling = false;
        this.bg = bg;
        this.sound = sound;
        this.sliderValue = sliderValue;
        this.screen = screen;
        this.setBtnToggleSound(sound);
        this.setBtnPlaySound(sound);
    }

    public void renderWidget(@NotNull GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
        this.isMuffling = this.getFGColor(this.getText(), "aqua");
        SoundMufflerCommon.renderGui();
        stack.fill(this.getX(), this.getY() - 1, this.getX() + this.width + 4, this.getY() + this.height - 2, this.bg);
        this.drawGradient(stack);
        float v = this.isMuffling ? 202.0f : 213.0f;
        stack.blit(SoundMufflerCommon.getTextureRL(), this.btnToggleSound.getX(), this.btnToggleSound.getY(), 43.0f, v, 11, 11, 256, 256);
        stack.blit(SoundMufflerCommon.getTextureRL(), this.btnPlaySound.getX(), this.btnPlaySound.getY(), 32.0f, 202.0f, 11, 11, 256, 256);
        if (this.btnToggleSound.isMouseOver((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (AbstractButton)this.btnToggleSound, (Component)(this.isMuffling ? Component.translatable((String)"slider.btn.muffler.unmuffle") : Component.translatable((String)"slider.btn.muffler.muffle")));
        }
        if (this.btnPlaySound.isMouseOver(mouseX, mouseY)) {
            this.renderButtonTooltip(stack, this.btnPlaySound, (Component)Component.translatable((String)"slider.btn.play.play_sound"));
        }
        this.drawMessage(stack);
    }

    private void renderButtonTooltip(GuiGraphics stack, AbstractButton button, Component message) {
        int centeredMessageX = button.getX() - this.font.width((FormattedText)message) / 2;
        int centeredMessageY = button.getY() - 1;
        stack.pose().pushPose();
        stack.renderTooltip(this.font, message, centeredMessageX, centeredMessageY);
        stack.pose().popPose();
    }

    private void drawMessage(GuiGraphics stack) {
        int v = Math.max(this.width, this.font.width(this.getMessage().getString()));
        if (showSlider && this.isFocused() && this.isHovered) {
            stack.drawCenteredString(this.font, (Component)Component.translatable((String)"slider.btn.volume", (Object[])new Object[]{(int)(this.sliderValue * 100.0)}), this.getX() + this.width / 2, this.getY() + 2, 65535);
        } else {
            String msgTruncated;
            if (this.isHovered) {
                msgTruncated = this.getMessage().getString();
                int n = this.getX() + this.width + 3;
                int n2 = this.getY();
                int n3 = this.getX() + v + 3;
                int n4 = this.getY();
                Objects.requireNonNull(this.font);
                stack.fill(n, n2, n3, n4 + 9 + 2, darkBG);
            } else {
                msgTruncated = this.font.substrByWidth((FormattedText)this.getMessage(), 205).getString();
            }
            stack.drawString(this.font, msgTruncated, this.getX() + 2, this.getY() + 2, this.isMuffling ? 65535 : 0xFFFFFF, true);
        }
    }

    private void drawGradient(GuiGraphics stack) {
        if (this.isMuffling) {
            stack.blit(SoundMufflerCommon.getTextureRL(), this.getX(), this.getY() - 1, 0.0f, 234.0f, (int)(this.sliderValue * (double)(this.width - 6)) + 5, this.height + 1, 256, 256);
            if (this.isHovered) {
                stack.blit(SoundMufflerCommon.getTextureRL(), this.getX() + (int)(this.sliderValue * (double)(this.width - 6)) + 1, this.getY() + 1, 32.0f, 224.0f, 5, 9, 256, 256);
            }
        }
    }

    public void isVisible(boolean b) {
        this.visible = b;
        this.getBtnToggleSound().visible = b;
        this.getBtnPlaySound().visible = b;
    }

    public void setY(int y) {
        super.setY(y);
        this.getBtnToggleSound().setY(y);
        this.getBtnPlaySound().setY(y);
    }

    private void setBtnToggleSound(ResourceLocation sound) {
        int x = CommonConfig.get().leftButtons().get() != false ? this.getX() - 26 : this.getX() + this.width + 4;
        this.btnToggleSound = Button.builder((Component)Component.empty(), b -> {
            if (this.isMuffling) {
                if (this.screen.removeSoundMuffled(sound)) {
                    this.setFGColor(this, "white");
                    if (this.screen.getBtnCSLTitle().equals(Component.translatable((String)"main_screen.btn.csl.muffled"))) {
                        this.visible = false;
                    }
                }
            } else {
                this.setSliderValue(CommonConfig.get().defaultMuteVolume().get());
                if (this.screen.addSoundMuffled(sound, this.sliderValue)) {
                    this.setFGColor(this, "aqua");
                }
            }
        }).bounds(x, this.getY(), 11, 11).build();
    }

    public Button getBtnToggleSound() {
        return this.btnToggleSound;
    }

    private void setBtnPlaySound(ResourceLocation sound) {
        this.btnPlaySound = new PlaySoundButton(this.btnToggleSound.getX() + 13, this.getY(), SoundEvent.createVariableRangeEvent((ResourceLocation)sound));
    }

    private PlaySoundButton getBtnPlaySound() {
        return this.btnPlaySound;
    }

    private void changeSliderValue(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.getX() + 4)) / (double)(this.width - 8));
    }

    private void setSliderValue(double value) {
        double d0 = this.sliderValue;
        this.sliderValue = Mth.clamp((double)value, (double)0.0, (double)0.9);
        if (d0 != this.sliderValue) {
            this.func_230972_a_();
        }
        this.func_230979_b_();
        this.screen.replaceVolume(this.sound, this.sliderValue);
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        this.changeSliderValue((float)mouseX);
        super.onDrag(mouseX, mouseY, dragX, dragY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.visible) {
            this.btnToggleSound.mouseClicked(mouseX, mouseY, button);
            this.btnPlaySound.mouseClicked(mouseX, mouseY, button);
            if (this.isHovered && this.isMuffling) {
                this.changeSliderValue((float)mouseX);
                showSlider = true;
                this.setFocused(true);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.setFocused(false);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private void func_230979_b_() {
    }

    private void func_230972_a_() {
    }

    private MutableComponent getText() {
        return this.getMessage().copy();
    }

    public void updateWidgetNarration(NarrationElementOutput elementOutput) {
        elementOutput.add(NarratedElementType.TITLE, (String)(this.isMuffling ? Component.translatable((String)"slider.btn.volume").toString() + (int)(this.sliderValue * 100.0) : this.sound.toString()));
    }
}

