/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.utils;

import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;

public class Anchor {
    private final int id;
    private BlockPos anchorPos;
    private String name;
    private ResourceLocation dimension;
    private int Radius;
    private SortedMap<String, Double> muffledSounds = new TreeMap<String, Double>();

    public Anchor(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public Anchor(int id, String name, BlockPos anchorPos, ResourceLocation dimension, int Radius, SortedMap<String, Double> muffledSounds) {
        this.id = id;
        this.name = name;
        this.anchorPos = anchorPos;
        this.dimension = dimension;
        this.Radius = Radius;
        this.muffledSounds = muffledSounds;
    }

    public BlockPos getAnchorPos() {
        return this.anchorPos;
    }

    private void setAnchorPos(BlockPos anchorPos) {
        this.anchorPos = anchorPos;
    }

    public int getAnchorId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getRadius() {
        return this.Radius;
    }

    public void setRadius(int Radius) {
        this.Radius = Radius;
    }

    private void setName(String name) {
        this.name = name;
    }

    public SortedMap<ResourceLocation, Double> getMuffledSounds() {
        TreeMap<ResourceLocation, Double> temp = new TreeMap<ResourceLocation, Double>();
        this.muffledSounds.forEach((R, D) -> temp.put(new ResourceLocation(R), (Double)D));
        return temp;
    }

    public void setMuffledSounds(SortedMap<ResourceLocation, Double> muffledSounds) {
        muffledSounds.forEach((R, D) -> this.muffledSounds.put(R.toString(), (Double)D));
    }

    public void addSound(ResourceLocation sound, double volume) {
        this.muffledSounds.put(sound.toString(), volume);
    }

    public void replaceSound(ResourceLocation sound, double volume) {
        this.muffledSounds.replace(sound.toString(), volume);
    }

    public String getX() {
        return this.anchorPos != null ? String.valueOf(this.anchorPos.getX()) : "";
    }

    public String getY() {
        return this.anchorPos != null ? String.valueOf(this.anchorPos.getY()) : "";
    }

    public String getZ() {
        return this.anchorPos != null ? String.valueOf(this.anchorPos.getZ()) : "";
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    private void setDimension(ResourceLocation dimension) {
        this.dimension = dimension;
    }

    public void removeSound(ResourceLocation sound) {
        this.muffledSounds.remove(sound.toString());
    }

    public void setAnchor() {
        LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
        this.setAnchorPos(player.blockPosition());
        this.setDimension(player.clientLevel.dimension().location());
        this.setRadius(this.getRadius() == 0 ? 32 : this.getRadius());
    }

    public void deleteAnchor() {
        this.setName("Anchor " + this.getAnchorId());
        this.setAnchorPos(null);
        this.setDimension(null);
        this.setRadius(0);
        this.muffledSounds.clear();
    }

    public void editAnchor(String title, int Radius) {
        this.setName(title);
        this.setRadius(Radius);
    }

    public static Anchor getAnchor(SoundInstance sound) {
        BlockPos soundPos = new BlockPos((int)sound.getX(), (int)sound.getY(), (int)sound.getZ());
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        ClientLevel world = minecraft.level;
        if (player != null && sound.getLocation().getPath().contains("entity.minecart.inside")) {
            soundPos = player.getOnPos();
        }
        for (Anchor anchor : ISoundLists.anchorList) {
            if (anchor.getAnchorPos() == null || world == null || !world.dimension().location().equals((Object)anchor.getDimension()) || !soundPos.closerThan((Vec3i)anchor.getAnchorPos(), (double)anchor.getRadius()) || !anchor.getMuffledSounds().containsKey(sound.getLocation())) continue;
            return anchor;
        }
        return null;
    }
}

