/*
 * Decompiled with CFR 0.152.
 */
package com.pam.pamhc2trees.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockPamLogFruit
extends Block
implements BonemealableBlock {
    private String name;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    public static boolean fruitRemoval = false;

    public BlockPamLogFruit(BlockBehaviour.Properties p_i49971_1_, String name) {
        super(p_i49971_1_);
        this.name = name;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.getValue((Property)this.getAgeProperty());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.getValue((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        super.tick(state, worldIn, pos, random);
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 7 && random.nextInt(5) == 0 && worldIn.getRawBrightness(pos.above(), 0) >= 9) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return (Integer)pState.getValue((Property)AGE) != 7;
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        int j;
        int i = this.getAge(pState) + this.getBonemealAgeIncrease((Level)pLevel);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        pLevel.setBlock(pPos, this.withAge(i), 2);
    }

    protected int getBonemealAgeIncrease(Level worldIn) {
        return Mth.nextInt((RandomSource)worldIn.random, (int)2, (int)5);
    }
}

