/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterjungletemples.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterjungletemples.mixin.accessor.ChunkGeneratorStructureStateAccessor;
import com.yungnickyoung.minecraft.betterjungletemples.module.StructurePlacementTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.structure.exclusion.EnhancedExclusionZone;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class BetterJungleTemplePlacement
extends RandomSpreadStructurePlacement {
    public static final Codec<BetterJungleTemplePlacement> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Vec3i.offsetCodec((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.ZERO).forGetter(placement -> placement.locateOffset()), (App)StructurePlacement.FrequencyReductionMethod.CODEC.optionalFieldOf("frequency_reduction_method", (Object)StructurePlacement.FrequencyReductionMethod.DEFAULT).forGetter(placement -> placement.frequencyReductionMethod()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(placement -> Float.valueOf(placement.frequency())), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("salt").forGetter(placement -> placement.salt()), (App)StructurePlacement.ExclusionZone.CODEC.optionalFieldOf("exclusion_zone").forGetter(placement -> placement.exclusionZone()), (App)EnhancedExclusionZone.CODEC.optionalFieldOf("enhanced_exclusion_zone").forGetter(placement -> placement.enhancedExclusionZone), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("spacing").forGetter(placement -> placement.spacing()), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("separation").forGetter(placement -> placement.separation()), (App)RandomSpreadType.CODEC.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(placement -> placement.spreadType())).apply((Applicative)builder, builder.stable(BetterJungleTemplePlacement::new))).flatXmap(BetterJungleTemplePlacement.verifySpacing(), DataResult::success).codec();
    private final Optional<EnhancedExclusionZone> enhancedExclusionZone;

    private static Function<BetterJungleTemplePlacement, DataResult<BetterJungleTemplePlacement>> verifySpacing() {
        return placement -> placement.spacing() <= placement.separation() ? DataResult.error(() -> "EnhancedRandomSpread's spacing has to be larger than separation") : DataResult.success((Object)placement);
    }

    public BetterJungleTemplePlacement(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, Float frequency, Integer salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, Optional<EnhancedExclusionZone> enhancedExclusionZone, Integer spacing, Integer separation, RandomSpreadType randomSpreadType) {
        super(locateOffset, frequencyReductionMethod, frequency.floatValue(), salt.intValue(), exclusionZone, spacing.intValue(), separation.intValue(), randomSpreadType);
        this.enhancedExclusionZone = enhancedExclusionZone;
    }

    public StructurePlacementType<?> type() {
        return StructurePlacementTypeModule.BETTER_JUNGLE_TEMPLE_PLACEMENT;
    }

    protected boolean isPlacementChunk(ChunkGeneratorStructureState state, int chunkX, int chunkZ) {
        BiomeSource biomeSource = ((ChunkGeneratorStructureStateAccessor)state).getBiomeSource();
        RandomState randomState = state.randomState();
        long seed = state.getLevelSeed();
        ChunkPos chunkPos = this.getPotentialStructureChunk(seed, chunkX, chunkZ);
        if (chunkPos.x == chunkX && chunkPos.z == chunkZ) {
            BlockPos structurePos = chunkPos.getMiddleBlockPosition(120);
            boolean isOceanOrRiverNear = biomeSource.findBiomeHorizontal(structurePos.getX(), structurePos.getY(), structurePos.getZ(), 48, 2, biomeHolder -> biomeHolder.is(BiomeTags.IS_RIVER) || biomeHolder.is(BiomeTags.IS_OCEAN), randomState.oreRandom().at(structurePos), true, randomState.sampler()) != null;
            return !isOceanOrRiverNear;
        }
        return false;
    }

    public boolean isStructureChunk(ChunkGeneratorStructureState state, int x, int z) {
        if (!super.isStructureChunk(state, x, z)) {
            return false;
        }
        return this.enhancedExclusionZone.isEmpty() || !this.enhancedExclusionZone.get().isPlacementForbidden(state, x, z);
    }
}

