/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.CamouflageableBlock;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.network.messages.RouterSettingsMessage;
import me.desht.modularrouters.network.messages.RouterUpgradesSyncMessage;
import me.desht.modularrouters.util.InventoryUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class ModularRouterBlock
extends CamouflageableBlock
implements EntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final BooleanProperty CAN_EMIT = BooleanProperty.create((String)"can_emit");

    public ModularRouterBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)CAN_EMIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ACTIVE, CAN_EMIT});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return Shapes.block();
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            world.getBlockEntity(pos, ModBlockEntities.MODULAR_ROUTER.get()).ifPresent(router -> {
                InventoryUtils.dropInventoryItems(world, pos, router.getBuffer());
                world.updateNeighbourForOutputSignal(pos, (Block)this);
                super.onRemove(state, world, pos, newState, isMoving);
            });
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        return world.getBlockEntity(pos, ModBlockEntities.MODULAR_ROUTER.get()).map(router -> ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)router.getBuffer())).orElse(0);
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter player, List<Component> tooltip, TooltipFlag advanced) {
        if (stack.hasTag()) {
            int i;
            CompoundTag compound = stack.getTag().getCompound("BlockEntityTag");
            tooltip.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.routerConfigured", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            if (compound.contains("Modules")) {
                ArrayList<MutableComponent> moduleText = new ArrayList<MutableComponent>();
                ItemStackHandler modulesHandler = new ItemStackHandler(9);
                modulesHandler.deserializeNBT(compound.getCompound("Modules"));
                for (i = 0; i < modulesHandler.getSlots(); ++i) {
                    ItemStack moduleStack = modulesHandler.getStackInSlot(i);
                    if (moduleStack.isEmpty()) continue;
                    moduleText.add(Component.literal((String)"\u2022 ").append(moduleStack.getHoverName()).withStyle(ChatFormatting.AQUA));
                }
                if (!moduleText.isEmpty()) {
                    tooltip.add((Component)ClientUtil.xlate("modularrouters.guiText.label.modules", new Object[0]).withStyle(ChatFormatting.YELLOW));
                    tooltip.addAll(moduleText);
                }
            }
            if (compound.contains("Upgrades")) {
                ItemStackHandler upgradesHandler = new ItemStackHandler();
                upgradesHandler.deserializeNBT(compound.getCompound("Upgrades"));
                ArrayList<MutableComponent> upgradeText = new ArrayList<MutableComponent>();
                for (i = 0; i < upgradesHandler.getSlots(); ++i) {
                    ItemStack upgradeStack = upgradesHandler.getStackInSlot(i);
                    if (upgradeStack.isEmpty()) continue;
                    upgradeText.add(Component.literal((String)("\u2022 " + upgradeStack.getCount() + " x ")).append(upgradeStack.getHoverName()).withStyle(ChatFormatting.AQUA));
                }
                if (!upgradeText.isEmpty()) {
                    tooltip.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.upgrades", new Object[0]).withStyle(ChatFormatting.YELLOW));
                    tooltip.addAll(upgradeText);
                }
            }
            if (compound.contains("Redstone")) {
                try {
                    RouterRedstoneBehaviour rrb = RouterRedstoneBehaviour.valueOf(compound.getString("Redstone"));
                    tooltip.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.redstone.label", new Object[0]).append(": ").withStyle(ChatFormatting.YELLOW).append((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.redstone." + rrb, new Object[0]).withStyle(ChatFormatting.RED)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        if (!player.isSteppingCarefully()) {
            return world.getBlockEntity(pos, ModBlockEntities.MODULAR_ROUTER.get()).map(router -> {
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    if (router.isPermitted(player)) {
                        PacketDistributor.PLAYER.with((Object)sp).send(new CustomPacketPayload[]{new RouterSettingsMessage((ModularRouterBlockEntity)router)});
                        PacketDistributor.PLAYER.with((Object)sp).send(new CustomPacketPayload[]{RouterUpgradesSyncMessage.forRouter(router)});
                        sp.openMenu((MenuProvider)router, pos);
                        return InteractionResult.SUCCESS;
                    }
                }
                if (router.isPermitted(player)) return InteractionResult.SUCCESS;
                if (!world.isClientSide) return InteractionResult.SUCCESS;
                player.displayClientMessage((Component)ClientUtil.xlate("modularrouters.chatText.security.accessDenied", new Object[0]).withStyle(ChatFormatting.RED), false);
                player.playSound(ModSounds.ERROR.get(), 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }).orElse(InteractionResult.FAIL);
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)CAN_EMIT);
    }

    @Override
    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockAccess.getBlockEntity(pos, ModBlockEntities.MODULAR_ROUTER.get()).map(router -> {
            int l = router.getRedstoneLevel(side, false);
            return l < 0 ? super.getSignal(blockState, blockAccess, pos, side) : l;
        }).orElse(0);
    }

    @Override
    public int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockAccess.getBlockEntity(pos, ModBlockEntities.MODULAR_ROUTER.get()).map(router -> {
            int l = router.getRedstoneLevel(side, true);
            return l < 0 ? super.getDirectSignal(blockState, blockAccess, pos, side) : l;
        }).orElse(0);
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean b) {
        worldIn.getBlockEntity(pos, ModBlockEntities.MODULAR_ROUTER.get()).ifPresent(router -> {
            router.checkForRedstonePulse();
            router.notifyModules();
        });
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return world.getBlockEntity(pos, ModBlockEntities.MODULAR_ROUTER.get()).map(router -> router.getUpgradeCount((Item)ModItems.BLAST_UPGRADE.get()) <= 0 && super.canEntityDestroy(state, world, pos, entity)).orElse(true);
    }

    @Override
    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return world.getBlockEntity(pos, ModBlockEntities.MODULAR_ROUTER.get()).map(router -> Float.valueOf(router.getUpgradeCount((Item)ModItems.BLAST_UPGRADE.get()) > 0 ? 20000.0f : this.explosionResistance)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ModularRouterBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof ModularRouterBlockEntity) {
                ModularRouterBlockEntity router = (ModularRouterBlockEntity)t;
                if (level1.isClientSide()) {
                    router.clientTick();
                } else {
                    router.serverTick();
                }
            }
        };
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }
}

