/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client;

import me.desht.modularrouters.block.tile.ICamouflageable;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModItems;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@Mod.EventBusSubscriber(modid="modularrouters", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ColorHandlers {
    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        for (DeferredHolder item : ModItems.ITEMS.getEntries()) {
            Object object = item.get();
            if (!(object instanceof ModItems.ITintable)) continue;
            ModItems.ITintable tintable = (ModItems.ITintable)object;
            event.register((stack, tintIndex) -> switch (tintIndex) {
                case 0, 2 -> TintColor.WHITE.getRGB();
                case 1 -> tintable.getItemTint().getRGB();
                default -> TintColor.BLACK.getRGB();
            }, new ItemLike[]{(ItemLike)item.get()});
        }
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((state, reader, pos, tintIndex) -> {
            ICamouflageable camouflageable;
            if (pos == null || reader == null) {
                return -1;
            }
            BlockEntity te = reader.getBlockEntity(pos);
            if (te instanceof ICamouflageable && (camouflageable = (ICamouflageable)te).getCamouflage() != null) {
                return event.getBlockColors().getColor(camouflageable.getCamouflage(), (BlockAndTintGetter)te.getLevel(), pos, tintIndex);
            }
            return 0xFFFFFF;
        }, new Block[]{(Block)ModBlocks.MODULAR_ROUTER.get(), ModBlocks.TEMPLATE_FRAME.get()});
    }
}

