/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import me.desht.modularrouters.client.gui.IMouseOverHelpProvider;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.XYPoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;

public class MouseOverHelp {
    private static final int TEXT_MARGIN = 8;
    private final List<HelpRegion> helpRegions = new ArrayList<HelpRegion>();
    private final AbstractContainerScreen<?> screen;
    private boolean active = false;

    public MouseOverHelp(AbstractContainerScreen<?> screen) {
        this.screen = screen;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void addHelpRegion(int x1, int y1, int x2, int y2, String key) {
        this.addHelpRegion(x1, y1, x2, y2, key, HelpRegion.YES);
    }

    public void addHelpRegion(int x1, int y1, int x2, int y2, Component key) {
        this.addHelpRegion(x1, y1, x2, y2, key, HelpRegion.YES);
    }

    public void addHelpRegion(int x1, int y1, int x2, int y2, String key, Predicate<AbstractContainerScreen<?>> showPredicate) {
        this.addHelpRegion(x1, y1, x2, y2, (Component)ClientUtil.xlate(key, new Object[0]), showPredicate);
    }

    public void addHelpRegion(int x1, int y1, int x2, int y2, Component key, Predicate<AbstractContainerScreen<?>> showPredicate) {
        List l = ComponentRenderUtils.wrapComponents((FormattedText)key, (int)this.screen.getXSize(), (Font)this.screen.getMinecraft().font);
        this.helpRegions.add(HelpRegion.create(x1, y1, x2, y2, l, showPredicate));
    }

    private void onMouseOver(GuiGraphics graphics, int mouseX, int mouseY) {
        HelpRegion region;
        if (this.active && (region = this.getRegionAt(mouseX, mouseY)) != null) {
            MouseOverHelp.showPopupBox(graphics, this.screen, Minecraft.getInstance().font, region.extent, -1073741824, 1614872575, 0, null);
            MouseOverHelp.showPopupBox(graphics, this.screen, Minecraft.getInstance().font, region.extent, -1073741824, -534765536, -2039584, region.text);
        }
    }

    private HelpRegion getRegionAt(int mouseX, int mouseY) {
        for (HelpRegion region : this.helpRegions) {
            if (!region.extent.contains(mouseX, mouseY) || !region.showPredicate.test(this.screen)) continue;
            return region;
        }
        return null;
    }

    private static Rect2i calcBounds(AbstractContainerScreen<?> screen, Font fontRenderer, Rect2i rect, List<FormattedCharSequence> helpText) {
        if (helpText != null && !helpText.isEmpty()) {
            int boxWidth = 0;
            int n = helpText.size();
            Objects.requireNonNull(fontRenderer);
            int boxHeight = n * 9;
            for (FormattedCharSequence s : helpText) {
                boxWidth = Math.max(boxWidth, fontRenderer.width(s));
            }
            int xOff = rect.getX() - screen.getGuiLeft() < screen.getXSize() / 2 ? rect.getWidth() + 10 : -(boxWidth + 8 + 10);
            int yOff = (rect.getHeight() - boxHeight - 8) / 2;
            return new Rect2i(rect.getX() + xOff, rect.getY() + yOff, boxWidth + 8, boxHeight + 8);
        }
        return rect;
    }

    private static void showPopupBox(GuiGraphics graphics, AbstractContainerScreen<?> screen, Font fontRenderer, Rect2i rect, int borderColor, int bgColor, int textColor, List<FormattedCharSequence> helpText) {
        Rect2i actualRect = MouseOverHelp.calcBounds(screen, fontRenderer, rect, helpText);
        int x1 = actualRect.getX() - screen.getGuiLeft();
        int y1 = actualRect.getY() - screen.getGuiTop();
        int x2 = x1 + actualRect.getWidth();
        int y2 = y1 + actualRect.getHeight();
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 300.0f);
        graphics.fill(x1, y1, x2, y2, bgColor);
        graphics.fill(x1, y1, x2, y1 + 1, borderColor);
        graphics.fill(x1, y2, x2, y2 + 1, borderColor);
        graphics.fill(x1, y1, x1 + 1, y2, borderColor);
        graphics.fill(x2, y1, x2 + 1, y2 + 1, borderColor);
        if (helpText != null) {
            for (FormattedCharSequence s : helpText) {
                graphics.drawString(fontRenderer, s, x1 + 4, y1 + 4, textColor);
                Objects.requireNonNull(fontRenderer);
                y1 += 9;
            }
        }
        graphics.pose().popPose();
    }

    @SubscribeEvent
    public static void drawMouseOver(ContainerScreenEvent.Render.Foreground event) {
        AbstractContainerScreen abstractContainerScreen = event.getContainerScreen();
        if (abstractContainerScreen instanceof IMouseOverHelpProvider) {
            IMouseOverHelpProvider provider = (IMouseOverHelpProvider)abstractContainerScreen;
            provider.getMouseOverHelp().onMouseOver(event.getGuiGraphics(), event.getMouseX(), event.getMouseY());
        }
    }

    public record HelpRegion(Rect2i extent, List<FormattedCharSequence> text, Predicate<AbstractContainerScreen<?>> showPredicate) {
        static final Predicate<AbstractContainerScreen<?>> YES = guiContainer -> true;

        static HelpRegion create(int x1, int y1, int x2, int y2, List<FormattedCharSequence> text, Predicate<AbstractContainerScreen<?>> showPredicate) {
            return new HelpRegion(new Rect2i(x1, y1, x2 - x1, y2 - y1), text, showPredicate);
        }
    }

    public static class Button
    extends TexturedToggleButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(192, 0);
        private static final XYPoint TEXTURE_XY_TOGGLED = new XYPoint(208, 0);

        public Button(int x, int y) {
            super(x, y, 16, 16, false, null);
            this.setTooltips((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.mouseOverHelp.false", new Object[0]), (Component)ClientUtil.xlate("modularrouters.guiText.tooltip.mouseOverHelp.true", new Object[0]));
        }

        public void onClick(double mouseX, double mouseY) {
            this.toggle();
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        @Override
        public boolean sendToServer() {
            return false;
        }

        @Override
        protected XYPoint getTextureXY() {
            return this.isToggled() ? TEXTURE_XY_TOGGLED : TEXTURE_XY;
        }
    }
}

