/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import me.desht.modularrouters.client.gui.IResyncableGui;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.container.AbstractSmartFilterMenu;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.network.messages.OpenGuiMessage;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class AbstractFilterContainerScreen
extends AbstractContainerScreen<AbstractSmartFilterMenu>
implements IResyncableGui {
    protected final InteractionHand hand;
    protected final String title;
    protected final ItemStack filterStack;

    AbstractFilterContainerScreen(AbstractSmartFilterMenu container, Inventory inv, Component displayName) {
        super((AbstractContainerMenu)container, inv, displayName);
        this.hand = container.getLocator().hand();
        this.filterStack = container.getFilterStack();
        this.title = this.filterStack.getHoverName().getString();
    }

    boolean closeGUI() {
        ItemStack stack;
        MFLocator locator = ((AbstractSmartFilterMenu)this.menu).getLocator();
        if (locator.routerPos() != null) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{OpenGuiMessage.openModuleInRouter(locator)});
            return true;
        }
        if (this.hand != null && (stack = this.getMinecraft().player.getItemInHand(this.hand)).getItem() instanceof ModuleItem) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{OpenGuiMessage.openModuleInHand(locator)});
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 256 || ClientUtil.isInvKey(keyCode)) && this.closeGUI()) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void resync(ItemStack stack) {
    }
}

