/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import me.desht.modularrouters.client.gui.IResyncableGui;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.network.FilterOp;
import me.desht.modularrouters.network.messages.FilterSettingsMessage;
import me.desht.modularrouters.network.messages.OpenGuiMessage;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class AbstractFilterScreen
extends Screen
implements IResyncableGui {
    protected final Component title;
    final MFLocator locator;

    AbstractFilterScreen(ItemStack filterStack, MFLocator locator) {
        super(filterStack.getHoverName());
        this.locator = locator;
        this.title = filterStack.getHoverName();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 256 || ClientUtil.isInvKey(keyCode)) && this.closeGUI()) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    boolean closeGUI() {
        ItemStack stack;
        if (this.locator.routerPos() != null) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{OpenGuiMessage.openModuleInRouter(this.locator)});
            return true;
        }
        if (this.locator.hand() != null && (stack = this.getMinecraft().player.getItemInHand(this.locator.hand())).getItem() instanceof ModuleItem) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{OpenGuiMessage.openModuleInHand(this.locator)});
            return true;
        }
        return false;
    }

    void sendAddStringMessage(String key, String s) {
        CompoundTag ext = (CompoundTag)Util.make((Object)new CompoundTag(), tag -> tag.putString(key, s));
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new FilterSettingsMessage(FilterOp.ADD_STRING, this.locator, ext)});
    }

    void sendRemovePosMessage(int pos) {
        CompoundTag ext = (CompoundTag)Util.make((Object)new CompoundTag(), tag -> tag.putInt("Pos", pos));
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new FilterSettingsMessage(FilterOp.REMOVE_AT, this.locator, ext)});
    }
}

