/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import java.util.EnumMap;
import java.util.Optional;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.ClientSetup;
import me.desht.modularrouters.client.gui.IMouseOverHelpProvider;
import me.desht.modularrouters.client.gui.ISendToServer;
import me.desht.modularrouters.client.gui.MouseOverHelp;
import me.desht.modularrouters.client.gui.filter.FilterScreenFactory;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.button.RadioButton;
import me.desht.modularrouters.client.gui.widgets.button.RedstoneBehaviourButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.network.messages.ModuleSettingsMessage;
import me.desht.modularrouters.network.messages.OpenGuiMessage;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.Range;

public class AbstractModuleScreen
extends AbstractContainerScreen<ModuleMenu>
implements ContainerListener,
IMouseOverHelpProvider,
ISendToServer {
    static final ResourceLocation GUI_TEXTURE = new ResourceLocation("modularrouters", "textures/gui/module.png");
    static final XYPoint SMALL_TEXTFIELD_XY = new XYPoint(0, 198);
    static final XYPoint LARGE_TEXTFIELD_XY = new XYPoint(0, 212);
    static final XYPoint BUTTON_XY = new XYPoint(0, 226);
    private static final int GUI_HEIGHT = 198;
    private static final int GUI_WIDTH = 192;
    private static final int BUTTON_WIDTH = 16;
    private static final int BUTTON_HEIGHT = 16;
    final ItemStack moduleItemStack;
    private final ModuleItem module;
    private final BlockPos routerPos;
    private final int moduleSlotIndex;
    private final InteractionHand hand;
    private ModuleItem.RelativeDirection facing;
    private int sendDelay;
    private int regulatorAmount;
    private final MouseOverHelp mouseOverHelp;
    final AugmentItem.AugmentCounter augmentCounter;
    private final boolean matchAll;
    private RedstoneBehaviourButton redstoneButton;
    private RegulatorTooltipButton regulatorTooltipButton;
    private final EnumMap<ModuleItem.RelativeDirection, DirectionButton> directionButtons = new EnumMap(ModuleItem.RelativeDirection.class);
    private final EnumMap<ModuleItem.ModuleFlags, ModuleToggleButton> toggleButtons = new EnumMap(ModuleItem.ModuleFlags.class);
    private MouseOverHelp.Button mouseOverHelpButton;
    private TexturedToggleButton matchAllButton;
    IntegerTextField regulatorTextField;
    private TerminationButton terminationButton;
    private static final int THRESHOLD = 129;

    public AbstractModuleScreen(ModuleMenu container, Inventory inventory, Component displayName) {
        super((AbstractContainerMenu)container, inventory, displayName);
        MFLocator locator = container.getLocator();
        this.moduleSlotIndex = locator.routerSlot();
        this.hand = locator.hand();
        this.routerPos = locator.routerPos();
        this.moduleItemStack = locator.getModuleStack(inventory.player);
        this.module = (ModuleItem)this.moduleItemStack.getItem();
        this.facing = ModuleHelper.getRelativeDirection(this.moduleItemStack);
        this.regulatorAmount = ModuleHelper.getRegulatorAmount(this.moduleItemStack);
        this.augmentCounter = new AugmentItem.AugmentCounter(this.moduleItemStack);
        this.matchAll = ModuleHelper.isMatchAll(this.moduleItemStack);
        this.imageWidth = 192;
        this.imageHeight = 198;
        this.mouseOverHelp = new MouseOverHelp(this);
        NeoForge.EVENT_BUS.addListener(this::onInitGui);
    }

    public void init() {
        super.init();
        this.addToggleButton(ModuleItem.ModuleFlags.BLACKLIST, 7, 75);
        this.addToggleButton(ModuleItem.ModuleFlags.IGNORE_DAMAGE, 7, 93);
        this.addToggleButton(ModuleItem.ModuleFlags.IGNORE_NBT, 25, 75);
        this.addToggleButton(ModuleItem.ModuleFlags.IGNORE_TAGS, 25, 93);
        this.terminationButton = (TerminationButton)this.addRenderableWidget((GuiEventListener)new TerminationButton(this.leftPos + 45, this.topPos + 93, ModuleHelper.getTermination(this.moduleItemStack)));
        this.matchAllButton = (TexturedToggleButton)this.addRenderableWidget((GuiEventListener)new MatchAllButton(this.leftPos + 45, this.topPos + 75, this.matchAll));
        if (this.module.isDirectional()) {
            this.addDirectionButton(ModuleItem.RelativeDirection.NONE, 70, 18);
            this.addDirectionButton(ModuleItem.RelativeDirection.UP, 87, 18);
            this.addDirectionButton(ModuleItem.RelativeDirection.LEFT, 70, 35);
            this.addDirectionButton(ModuleItem.RelativeDirection.FRONT, 87, 35);
            this.addDirectionButton(ModuleItem.RelativeDirection.RIGHT, 104, 35);
            this.addDirectionButton(ModuleItem.RelativeDirection.DOWN, 87, 52);
            this.addDirectionButton(ModuleItem.RelativeDirection.BACK, 104, 52);
        }
        this.mouseOverHelpButton = (MouseOverHelp.Button)this.addRenderableWidget((GuiEventListener)new MouseOverHelp.Button(this.leftPos + 175, this.topPos + 1));
        this.redstoneButton = (RedstoneBehaviourButton)this.addRenderableWidget((GuiEventListener)new RedstoneBehaviourButton(this.leftPos + 170, this.topPos + 93, 16, 16, ModuleHelper.getRedstoneBehaviour(this.moduleItemStack), (ISendToServer)this));
        this.regulatorTextField = (IntegerTextField)this.addRenderableWidget((GuiEventListener)this.buildRegulationTextField());
        this.regulatorTooltipButton = (RegulatorTooltipButton)this.addRenderableWidget((GuiEventListener)new RegulatorTooltipButton(this.regulatorTextField.getX() - 16, this.regulatorTextField.getY() - 2, this.module.isFluidModule()));
        if (this.routerPos != null) {
            this.addRenderableWidget((GuiEventListener)new BackButton(this.leftPos + 2, this.topPos + 1, p -> PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{OpenGuiMessage.openRouter(((ModuleMenu)this.menu).getLocator())})));
        }
        this.mouseOverHelp.addHelpRegion(this.leftPos + 7, this.topPos + 16, this.leftPos + 60, this.topPos + 69, "modularrouters.guiText.popup.filter");
        this.mouseOverHelp.addHelpRegion(this.leftPos + 5, this.topPos + 73, this.leftPos + 62, this.topPos + 110, "modularrouters.guiText.popup.filterControl");
        this.mouseOverHelp.addHelpRegion(this.leftPos + 68, this.topPos + 16, this.leftPos + 121, this.topPos + 69, this.module.isDirectional() ? "modularrouters.guiText.popup.direction" : "modularrouters.guiText.popup.noDirection");
        this.mouseOverHelp.addHelpRegion(this.leftPos + 77, this.topPos + 74, this.leftPos + 112, this.topPos + 109, "modularrouters.guiText.popup.augments");
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
    }

    protected IntegerTextField buildRegulationTextField() {
        IntegerTextField tf = new IntegerTextField(this.font, this.leftPos + 166, this.topPos + 75, 20, 12, (Range<Integer>)Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(64)));
        tf.setValue(this.regulatorAmount);
        tf.setResponder(str -> {
            this.regulatorAmount = str.isEmpty() ? 0 : Integer.parseInt(str);
            this.sendModuleSettingsDelayed(5);
        });
        return tf;
    }

    public void onInitGui(ScreenEvent.Init.Post event) {
        ((ModuleMenu)this.getMenu()).removeSlotListener(this);
        ((ModuleMenu)this.getMenu()).addSlotListener(this);
        this.setupButtonVisibility();
    }

    public int getRegulatorAmount() {
        return this.regulatorAmount;
    }

    public void setRegulatorAmount(int regulatorAmount) {
        this.regulatorAmount = regulatorAmount;
    }

    protected void setupButtonVisibility() {
        this.redstoneButton.visible = this.augmentCounter.getAugmentCount((Item)ModItems.REDSTONE_AUGMENT.get()) > 0;
        this.regulatorTooltipButton.visible = this.augmentCounter.getAugmentCount((Item)ModItems.REGULATOR_AUGMENT.get()) > 0;
        this.regulatorTextField.setVisible(this.regulatorTooltipButton.visible);
    }

    private void addToggleButton(ModuleItem.ModuleFlags flag, int x, int y) {
        this.toggleButtons.put(flag, new ModuleToggleButton(flag, this.leftPos + x, this.topPos + y, ModuleHelper.checkFlag(this.moduleItemStack, flag)));
        this.addRenderableWidget((GuiEventListener)this.toggleButtons.get((Object)flag));
    }

    private void addDirectionButton(ModuleItem.RelativeDirection dir, int x, int y) {
        this.directionButtons.put(dir, new DirectionButton(dir, this.module, this.leftPos + x, this.topPos + y, dir == this.facing));
        this.addRenderableWidget((GuiEventListener)this.directionButtons.get((Object)dir));
    }

    public void containerTick() {
        super.containerTick();
        this.mouseOverHelp.setActive(this.mouseOverHelpButton.isToggled());
        if (this.sendDelay > 0 && --this.sendDelay <= 0) {
            this.sendToServer();
        }
    }

    void sendModuleSettingsDelayed(int delay) {
        this.sendDelay = delay;
    }

    @Override
    public void sendToServer() {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ModuleSettingsMessage(((ModuleMenu)this.menu).getLocator(), this.buildMessageData())});
    }

    protected CompoundTag buildMessageData() {
        RouterRedstoneBehaviour behaviour = this.redstoneButton == null ? RouterRedstoneBehaviour.ALWAYS : (RouterRedstoneBehaviour)this.redstoneButton.getState();
        return (CompoundTag)Util.make((Object)new CompoundTag(), tag -> {
            for (ModuleItem.ModuleFlags flag : ModuleItem.ModuleFlags.values()) {
                tag.putBoolean(flag.getName(), this.toggleButtons.get((Object)flag).isToggled());
            }
            tag.putString("Termination", ((ModuleItem.Termination)this.terminationButton.getState()).toString());
            tag.putString("Direction", this.facing.toString());
            tag.putByte("RedstoneMode", (byte)behaviour.ordinal());
            tag.putInt("RegulatorAmount", this.regulatorAmount);
            tag.putBoolean("MatchAll", this.matchAllButton.isToggled());
        });
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        MutableComponent txt = this.moduleItemStack.getHoverName().copy().append(" ").append((Component)(this.routerPos != null ? ClientUtil.xlate("modularrouters.guiText.label.installed", new Object[0]) : Component.empty()));
        graphics.drawString(this.font, (Component)txt, this.imageWidth / 2 - this.font.width((FormattedText)txt) / 2, 5, this.getFgColor(this.module.getItemTint()), false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        TintColor c = this.getGuiBackgroundTint();
        graphics.setColor((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 1.0f);
        graphics.blit(GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (!this.module.isDirectional()) {
            graphics.blit(GUI_TEXTURE, this.leftPos + 69, this.topPos + 17, 204, 0, 52, 52);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected TintColor getGuiBackgroundTint() {
        if (((Boolean)ConfigHolder.client.misc.moduleGuiBackgroundTint.get()).booleanValue()) {
            TintColor c = this.module.getItemTint();
            float[] hsb = TintColor.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            return TintColor.getHSBColor(hsb[0], hsb[1] * 0.5f, hsb[2]);
        }
        return TintColor.WHITE;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 256 || ClientUtil.isInvKey(keyCode) && !this.isFocused()) && this.routerPos != null) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{OpenGuiMessage.openRouter(((ModuleMenu)this.menu).getLocator())});
            return true;
        }
        if (ClientSetup.keybindConfigure.getKey().getValue() == keyCode) {
            return this.handleFilterConfig();
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double x, double y, int button) {
        return button == 2 ? this.handleFilterConfig() : super.mouseClicked(x, y, button);
    }

    private boolean handleFilterConfig() {
        SmartFilterItem filter;
        Slot slot;
        block11: {
            block10: {
                Item item;
                slot = this.getSlotUnderMouse();
                if (slot == null || !((item = slot.getItem().getItem()) instanceof SmartFilterItem)) break block10;
                filter = (SmartFilterItem)item;
                if (slot.index >= 0 && slot.index < 9) break block11;
            }
            return false;
        }
        int filterSlotIndex = slot.index;
        if (this.routerPos != null) {
            MFLocator locator = MFLocator.filterInInstalledModule(this.routerPos, this.moduleSlotIndex, filterSlotIndex);
            if (filter.hasMenu()) {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{OpenGuiMessage.openFilterInInstalledModule(locator)});
            } else {
                FilterScreenFactory.openFilterGui(locator);
            }
        } else if (this.hand != null) {
            MFLocator locator = MFLocator.filterInHeldModule(this.hand, filterSlotIndex);
            if (filter.hasMenu()) {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{OpenGuiMessage.openFilterInHeldModule(locator)});
            } else {
                FilterScreenFactory.openFilterGui(locator);
            }
        }
        return true;
    }

    public void removed() {
        super.removed();
        if (this.sendDelay > 0) {
            this.sendToServer();
        }
    }

    Optional<ModularRouterBlockEntity> getItemRouter() {
        return this.routerPos != null ? Minecraft.getInstance().level.getBlockEntity(this.routerPos, ModBlockEntities.MODULAR_ROUTER.get()) : Optional.empty();
    }

    public void slotChanged(AbstractContainerMenu containerToSend, int slotInd, ItemStack stack) {
        if (slotInd >= 9 && slotInd < 13) {
            this.augmentCounter.refresh(this.moduleItemStack);
            this.setupButtonVisibility();
        }
    }

    public void dataChanged(AbstractContainerMenu abstractContainerMenu, int i, int i1) {
    }

    private int getFgColor(TintColor bg) {
        int luminance = (int)Math.sqrt((double)(bg.getRed() * bg.getRed()) * 0.241 + (double)(bg.getGreen() * bg.getGreen()) * 0.691 + (double)(bg.getBlue() * bg.getBlue()) * 0.068);
        return luminance > 129 ? 0x404040 : 0xFFFFFF;
    }

    @Override
    public MouseOverHelp getMouseOverHelp() {
        return this.mouseOverHelp;
    }

    private class TerminationButton
    extends TexturedCyclerButton<ModuleItem.Termination> {
        public TerminationButton(int x, int y, ModuleItem.Termination initialVal) {
            super(x, y, 16, 16, initialVal, AbstractModuleScreen.this);
        }

        @Override
        protected Tooltip makeTooltip(ModuleItem.Termination termination) {
            return Tooltip.create((Component)ClientUtil.xlate(termination.getTranslationKey() + ".header", new Object[0]).append("\n").append((Component)ClientUtil.xlate(termination.getTranslationKey(), new Object[0])));
        }

        @Override
        protected XYPoint getTextureXY() {
            int x = switch ((ModuleItem.Termination)this.getState()) {
                default -> throw new IncompatibleClassChangeError();
                case ModuleItem.Termination.NONE -> 128;
                case ModuleItem.Termination.NOT_RAN -> 224;
                case ModuleItem.Termination.RAN -> 144;
            };
            return new XYPoint(x, 32);
        }
    }

    private class MatchAllButton
    extends TexturedToggleButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(208, 16);
        private static final XYPoint TEXTURE_XY_TOGGLED = new XYPoint(224, 16);

        MatchAllButton(int x, int y, boolean toggled) {
            super(x, y, 16, 16, toggled, AbstractModuleScreen.this);
            this.setTooltips((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.matchAll.false", new Object[0]), (Component)ClientUtil.xlate("modularrouters.guiText.tooltip.matchAll.true", new Object[0]));
        }

        @Override
        protected XYPoint getTextureXY() {
            return this.isToggled() ? TEXTURE_XY_TOGGLED : TEXTURE_XY;
        }
    }

    private static class RegulatorTooltipButton
    extends TexturedButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(112, 0);

        RegulatorTooltipButton(int x, int y, boolean isFluid) {
            super(x, y, 16, 16, p -> {});
            ClientUtil.setMultilineTooltip((AbstractWidget)this, new Component[]{Component.translatable((String)(isFluid ? "modularrouters.guiText.tooltip.fluidRegulatorTooltip" : "modularrouters.guiText.tooltip.regulatorTooltip")), Component.translatable((String)"modularrouters.guiText.tooltip.numberFieldTooltip")});
        }

        @Override
        protected XYPoint getTextureXY() {
            return TEXTURE_XY;
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        public void playDownSound(SoundManager soundHandlerIn) {
        }
    }

    private class ModuleToggleButton
    extends TexturedToggleButton {
        private final ModuleItem.ModuleFlags flag;

        ModuleToggleButton(ModuleItem.ModuleFlags flag, int x, int y, boolean toggled) {
            super(x, y, 16, 16, toggled, AbstractModuleScreen.this);
            this.flag = flag;
            this.setTooltips((Component)ClientUtil.xlate("modularrouters.guiText.tooltip." + flag + ".1", new Object[0]), (Component)ClientUtil.xlate("modularrouters.guiText.tooltip." + flag + ".2", new Object[0]));
        }

        @Override
        protected XYPoint getTextureXY() {
            return new XYPoint(this.flag.ordinal() * 16 * 2 + (this.isToggled() ? 16 : 0), this.flag.getTextureY());
        }
    }

    private class DirectionButton
    extends RadioButton {
        private static final int DIRECTION_GROUP = 1;
        private final ModuleItem.RelativeDirection direction;

        DirectionButton(ModuleItem.RelativeDirection dir, ModuleItem module, int x, int y, boolean toggled) {
            super(1, x, y, 16, 16, toggled, AbstractModuleScreen.this);
            this.direction = dir;
            this.setTooltips((Component)module.getDirectionString(dir).withStyle(ChatFormatting.GRAY), (Component)module.getDirectionString(dir).withStyle(ChatFormatting.YELLOW));
        }

        @Override
        protected XYPoint getTextureXY() {
            return new XYPoint(this.direction.getTextureX(this.isToggled()), this.direction.getTextureY());
        }

        public ModuleItem.RelativeDirection getDirection() {
            return this.direction;
        }

        public void onPress() {
            for (ModuleItem.RelativeDirection dir : ModuleItem.RelativeDirection.values()) {
                DirectionButton db = AbstractModuleScreen.this.directionButtons.get((Object)dir);
                db.setToggled(false);
                if (db != this) continue;
                AbstractModuleScreen.this.facing = db.getDirection();
            }
            super.onPress();
        }
    }
}

