/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import java.util.Arrays;
import me.desht.modularrouters.client.gui.module.AbstractModuleScreen;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.integration.XPCollection;
import me.desht.modularrouters.logic.compiled.CompiledVacuumModule;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class VacuumModuleScreen
extends AbstractModuleScreen {
    private XPTypeButton xpb;
    private EjectButton ejb;

    public VacuumModuleScreen(ModuleMenu container, Inventory inv, Component displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void init() {
        super.init();
        CompiledVacuumModule vac = new CompiledVacuumModule(null, this.moduleItemStack);
        ItemStack[] icons = (ItemStack[])Arrays.stream(XPCollection.XPCollectionType.values()).map(XPCollection.XPCollectionType::getIcon).toArray(ItemStack[]::new);
        this.xpb = new XPTypeButton(this.leftPos + 127, this.topPos + 30, 20, 20, false, icons, vac.getXPCollectionType());
        this.addRenderableWidget((GuiEventListener)this.xpb);
        this.ejb = new EjectButton(this.leftPos + 127, this.topPos + 64, vac.isAutoEjecting());
        this.addRenderableWidget((GuiEventListener)this.ejb);
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 125, this.topPos + 16, this.leftPos + 187, this.topPos + 52, "modularrouters.guiText.popup.xpVacuum", guiContainer -> this.xpb.visible);
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 125, this.topPos + 52, this.leftPos + 187, this.topPos + 88, "modularrouters.guiText.popup.xpVacuum.eject", guiContainer -> this.xpb.visible && this.ejb.visible);
    }

    @Override
    protected void setupButtonVisibility() {
        super.setupButtonVisibility();
        this.xpb.visible = this.augmentCounter.getAugmentCount((Item)ModItems.XP_VACUUM_AUGMENT.get()) > 0;
        this.ejb.visible = this.xpb.visible && !((XPCollection.XPCollectionType)this.xpb.getState()).isSolid();
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        if (this.augmentCounter.getAugmentCount((Item)ModItems.XP_VACUUM_AUGMENT.get()) > 0) {
            graphics.drawString(this.font, (Component)ClientUtil.xlate("modularrouters.guiText.label.xpVacuum", new Object[0]), 127, 18, 0xFFFFFF);
            if (!((XPCollection.XPCollectionType)this.xpb.getState()).isSolid()) {
                graphics.drawString(this.font, (Component)ClientUtil.xlate("modularrouters.guiText.label.xpVacuum.eject", new Object[0]), 127, 52, 0xFFFFFF);
            }
        }
    }

    @Override
    protected CompoundTag buildMessageData() {
        return (CompoundTag)Util.make((Object)super.buildMessageData(), compound -> {
            compound.putInt("XPFluidType", ((XPCollection.XPCollectionType)this.xpb.getState()).ordinal());
            compound.putBoolean("AutoEject", this.ejb.isToggled());
        });
    }

    private class XPTypeButton
    extends ItemStackCyclerButton<XPCollection.XPCollectionType> {
        XPTypeButton(int x, int y, int width, int height, boolean flat, ItemStack[] stacks, XPCollection.XPCollectionType initialVal) {
            super(x, y, width, height, flat, stacks, initialVal, VacuumModuleScreen.this);
        }

        @Override
        protected Tooltip makeTooltip(XPCollection.XPCollectionType type) {
            return Tooltip.create((Component)type.getDisplayName().copy().append("\n").append((Component)Component.literal((String)ModNameCache.getModName(type.getModId())).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
        }

        @Override
        public void setState(XPCollection.XPCollectionType newState) {
            super.setState(newState);
            if (VacuumModuleScreen.this.ejb != null) {
                VacuumModuleScreen.this.ejb.visible = this.visible && !((XPCollection.XPCollectionType)VacuumModuleScreen.this.xpb.getState()).isSolid();
            }
        }

        @Override
        public boolean isApplicable(XPCollection.XPCollectionType state) {
            return state.isAvailable();
        }
    }

    private class EjectButton
    extends TexturedToggleButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(112, 16);
        private static final XYPoint TEXTURE_XY_TOGGLED = new XYPoint(192, 16);

        EjectButton(int x, int y, boolean initialVal) {
            super(x, y, 16, 16, initialVal, VacuumModuleScreen.this);
        }

        @Override
        protected XYPoint getTextureXY() {
            return this.isToggled() ? TEXTURE_XY_TOGGLED : TEXTURE_XY;
        }
    }
}

