/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.upgrade;

import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.item.upgrade.SyncUpgrade;
import me.desht.modularrouters.network.messages.SyncUpgradeSettingsMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.Range;

public class SyncUpgradeScreen
extends Screen {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("modularrouters", "textures/gui/sync_upgrade.png");
    private static final ItemStack clockStack = new ItemStack((ItemLike)Items.CLOCK);
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 48;
    private final String title;
    private int xPos;
    private int yPos;
    private final int currentVal;
    private final InteractionHand hand;
    private IntegerTextField intField;

    public SyncUpgradeScreen(ItemStack upgradeStack, InteractionHand hand) {
        super(upgradeStack.getHoverName());
        this.title = upgradeStack.getHoverName().getString();
        this.currentVal = SyncUpgrade.getTunedValue(upgradeStack);
        this.hand = hand;
    }

    public static void openSyncGui(ItemStack stack, InteractionHand hand) {
        Minecraft.getInstance().setScreen((Screen)new SyncUpgradeScreen(stack, hand));
    }

    public void init() {
        super.init();
        this.xPos = (this.width - 176) / 2;
        this.yPos = (this.height - 48) / 2;
        this.intField = new IntegerTextField(this.font, this.xPos + 77, this.yPos + 27, 25, 16, (Range<Integer>)Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf((Integer)ConfigHolder.common.router.baseTickRate.get() - 1)));
        this.intField.setValue(this.currentVal);
        this.intField.useGuiTextBackground();
        this.intField.setFocused(true);
        this.setFocused((GuiEventListener)this.intField);
        this.addRenderableWidget((GuiEventListener)this.intField);
        this.addRenderableWidget((GuiEventListener)new TooltipButton(this.xPos + 55, this.yPos + 24, 16, 16));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawString(this.font, this.title, this.xPos + 88 - this.font.width(this.title) / 2, this.yPos + 6, 0x404040, false);
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.blit(TEXTURE_LOCATION, this.xPos, this.yPos, 0, 0, 176, 48);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        int newVal = this.intField.getIntValue();
        if (this.currentVal != newVal) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new SyncUpgradeSettingsMessage(newVal, this.hand)});
        }
        super.onClose();
    }

    private static class TooltipButton
    extends ItemStackButton {
        TooltipButton(int x, int y, int width, int height) {
            super(x, y, width, height, clockStack, true, p -> {});
            ClientUtil.setMultilineTooltip((AbstractWidget)this, new Component[]{ClientUtil.xlate("modularrouters.guiText.tooltip.tunedValue", 0, (Integer)ConfigHolder.common.router.baseTickRate.get() - 1).withStyle(ChatFormatting.AQUA), ClientUtil.xlate("modularrouters.guiText.tooltip.numberFieldTooltip", new Object[0])});
        }

        public void playDownSound(SoundManager soundHandlerIn) {
        }
    }
}

