/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets.button;

import me.desht.modularrouters.client.gui.ISendToServer;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.util.TranslatableEnum;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class ItemStackCyclerButton<T extends Enum<T>>
extends ItemStackButton {
    private T state;
    private final int len;
    private final ItemStack[] stacks;

    public ItemStackCyclerButton(int x, int y, int width, int height, boolean flat, ItemStack[] stacks, T initialVal, ISendToServer dataSyncer) {
        super(x, y, width, height, null, flat, button -> {
            ((ItemStackCyclerButton)button).cycle(!Screen.hasShiftDown());
            dataSyncer.sendToServer();
        });
        this.len = ((Enum[])initialVal.getClass().getEnumConstants()).length;
        if (stacks.length != this.len) {
            throw new IllegalArgumentException("stacks parameter must have length=" + this.len);
        }
        this.setState(initialVal);
        this.stacks = stacks;
    }

    public T getState() {
        return this.state;
    }

    public void setState(T newState) {
        this.state = newState;
        this.setTooltip(this.makeTooltip(this.state));
    }

    protected Tooltip makeTooltip(T object) {
        return Tooltip.create((Component)ClientUtil.xlate(((TranslatableEnum)object).getTranslationKey(), new Object[0]));
    }

    private void cycle(boolean forward) {
        Enum newState;
        int b = ((Enum)this.state).ordinal();
        do {
            if ((b += forward ? 1 : -1) >= this.len) {
                b = 0;
                continue;
            }
            if (b >= 0) continue;
            b = this.len - 1;
        } while (!this.isApplicable(newState = ((Enum[])this.state.getClass().getEnumConstants())[b]) && b != ((Enum)this.state).ordinal());
        this.setState(newState);
    }

    public boolean isApplicable(T state) {
        return true;
    }

    @Override
    public ItemStack getRenderStack() {
        return this.stacks[((Enum)this.state).ordinal()];
    }
}

