/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets.button;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import me.desht.modularrouters.client.util.GuiUtil;
import me.desht.modularrouters.client.util.XYPoint;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;

public abstract class TexturedButton
extends ExtendedButton {
    static final ResourceLocation TEXTURE = new ResourceLocation("modularrouters", "textures/gui/widgets.png");

    public TexturedButton(int x, int y, int width, int height, Button.OnPress pressable) {
        super(x, y, width, height, (Component)Component.empty(), pressable);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            int i = this.getYImage(this.isHovered);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            if (this.drawStandardBackground()) {
                graphics.blit(TEXTURE, this.getX(), this.getY(), i * 16, 0, this.width, this.height);
            }
            graphics.blit(TEXTURE, this.getX(), this.getY(), this.getTextureX(), this.getTextureY(), this.width, this.height);
            if (this.isHoveredOrFocused()) {
                GuiUtil.drawFrame(graphics, (AbstractWidget)this, -1);
            }
        }
    }

    protected int getYImage(boolean pIsHovered) {
        int i = 1;
        if (!this.active) {
            i = 0;
        } else if (pIsHovered) {
            i = 2;
        }
        return i;
    }

    protected boolean drawStandardBackground() {
        return true;
    }

    protected abstract XYPoint getTextureXY();

    final int getTextureX() {
        return this.getTextureXY().x();
    }

    final int getTextureY() {
        return this.getTextureXY().y();
    }
}

