/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.modularrouters.block.ModularRouterBlock;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.render.ModRenderTypes;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.util.BeamData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ModularRouterBER
implements BlockEntityRenderer<ModularRouterBlockEntity> {
    private static final Vector3f ROTATION = new Vector3f(0.15f, 1.0f, 0.0f);
    private static final float CAMO_HIGHLIGHT_SIZE = 0.75f;
    private static final float[] COLS = new float[]{0.5f, 0.5f, 1.0f, 0.25f};

    public ModularRouterBER(BlockEntityRendererProvider.Context ctx) {
    }

    public AABB getRenderBoundingBox(ModularRouterBlockEntity blockEntity) {
        return blockEntity.getRenderBoundingBox();
    }

    public void render(ModularRouterBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        Vec3 routerVec = Vec3.atCenterOf((Vec3i)te.getBlockPos());
        for (BeamData beam : te.beams) {
            matrixStack.pushPose();
            matrixStack.translate(-routerVec.x(), -routerVec.y(), -routerVec.z());
            Vec3 startPos = beam.getStart(routerVec);
            Vec3 endPos = beam.getEnd(routerVec);
            float progress = beam.getProgress(partialTicks);
            if (((Boolean)ConfigHolder.client.misc.renderFlyingItems.get()).booleanValue()) {
                this.renderFlyingItem(beam, matrixStack, buffer, progress, startPos, endPos);
            }
            this.renderBeamLine(beam, matrixStack, buffer, progress, startPos, endPos);
            matrixStack.popPose();
        }
        matrixStack.popPose();
        LocalPlayer player = Minecraft.getInstance().player;
        if (((Boolean)ConfigHolder.client.misc.heldRouterShowsCamoRouters.get()).booleanValue() && te.getCamouflage() != null && ModularRouterBER.playerHoldingRouter((Player)player) && Vec3.atCenterOf((Vec3i)te.getBlockPos()).distanceToSqr(player.position()) < 256.0) {
            this.renderCamoHighlight(matrixStack, buffer);
        }
    }

    private void renderCamoHighlight(PoseStack poseStack, MultiBufferSource buffer) {
        poseStack.pushPose();
        double start = 0.125;
        poseStack.translate(start, start, start);
        this.addVertices(buffer.getBuffer(ModRenderTypes.BLOCK_HILIGHT_FACE), poseStack.last().pose());
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer.getBuffer(ModRenderTypes.BLOCK_HILIGHT_LINE), (double)0.0, (double)0.0, (double)0.0, (double)0.75, (double)0.75, (double)0.75, (float)0.5f, (float)0.5f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    private void addVertices(VertexConsumer wr, Matrix4f posMat) {
        wr.vertex(posMat, 0.0f, 0.0f, 0.0f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, 0.0f, -1.0f).endVertex();
        wr.vertex(posMat, 0.0f, 0.75f, 0.0f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, 0.0f, -1.0f).endVertex();
        wr.vertex(posMat, 0.75f, 0.75f, 0.0f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, 0.0f, -1.0f).endVertex();
        wr.vertex(posMat, 0.75f, 0.0f, 0.0f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, 0.0f, -1.0f).endVertex();
        wr.vertex(posMat, 0.75f, 0.0f, 0.75f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, 0.0f, 1.0f).endVertex();
        wr.vertex(posMat, 0.75f, 0.75f, 0.75f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, 0.0f, 1.0f).endVertex();
        wr.vertex(posMat, 0.0f, 0.75f, 0.75f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, 0.0f, 1.0f).endVertex();
        wr.vertex(posMat, 0.0f, 0.0f, 0.75f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, 0.0f, 1.0f).endVertex();
        wr.vertex(posMat, 0.0f, 0.0f, 0.0f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(-1.0f, 0.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.0f, 0.0f, 0.75f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(-1.0f, 0.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.0f, 0.75f, 0.75f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(-1.0f, 0.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.0f, 0.75f, 0.0f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(-1.0f, 0.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.75f, 0.75f, 0.0f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(1.0f, 0.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.75f, 0.75f, 0.75f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(1.0f, 0.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.75f, 0.0f, 0.75f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(1.0f, 0.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.75f, 0.0f, 0.0f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(1.0f, 0.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.0f, 0.0f, 0.0f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, -1.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.75f, 0.0f, 0.0f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, -1.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.75f, 0.0f, 0.75f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, -1.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.0f, 0.0f, 0.75f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, -1.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.0f, 0.75f, 0.75f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, 1.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.75f, 0.75f, 0.75f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, 1.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.75f, 0.75f, 0.0f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, 1.0f, 0.0f).endVertex();
        wr.vertex(posMat, 0.0f, 0.75f, 0.0f).color(COLS[0], COLS[1], COLS[2], COLS[3]).normal(0.0f, 1.0f, 0.0f).endVertex();
    }

    private static boolean playerHoldingRouter(Player player) {
        Item router = ((ModularRouterBlock)((Object)ModBlocks.MODULAR_ROUTER.get())).asItem();
        return player.getMainHandItem().getItem() == router || player.getOffhandItem().getItem() == router;
    }

    private void renderFlyingItem(BeamData beam, PoseStack matrixStack, MultiBufferSource buffer, float progress, Vec3 startPos, Vec3 endPos) {
        double iz;
        double iy;
        ClientLevel world = Minecraft.getInstance().level;
        double ix = Mth.lerp((double)progress, (double)startPos.x(), (double)endPos.x());
        BlockPos pos = BlockPos.containing((double)ix, (double)(iy = Mth.lerp((double)progress, (double)startPos.y(), (double)endPos.y())), (double)(iz = Mth.lerp((double)progress, (double)startPos.z(), (double)endPos.z())));
        VoxelShape shape = world.getBlockState(pos).getCollisionShape((BlockGetter)world, pos);
        if (shape.isEmpty() || !shape.bounds().move(pos).contains(ix, iy, iz)) {
            matrixStack.pushPose();
            matrixStack.translate(ix, iy - 0.15, iz);
            matrixStack.mulPose(Axis.of((Vector3f)ROTATION).rotationDegrees(progress * 360.0f));
            if (beam.isItemFade()) {
                matrixStack.translate(0.0, 0.15, 0.0);
                matrixStack.scale(1.15f - progress, 1.15f - progress, 1.15f - progress);
                if ((double)progress > 0.95 && world.random.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.PORTAL, endPos.x(), endPos.y(), endPos.z(), 0.5 - world.random.nextDouble(), -0.5, 0.5 - world.random.nextDouble());
                }
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(beam.getStack(), ItemDisplayContext.GROUND, 0xF000F0, OverlayTexture.NO_OVERLAY, matrixStack, buffer, (Level)world, 0);
            matrixStack.popPose();
        }
    }

    private void renderBeamLine(BeamData beam, PoseStack matrixStack, MultiBufferSource buffer, float progress, Vec3 startPos, Vec3 endPos) {
        int alpha = (int)(Mth.sin((float)((float)(Minecraft.getInstance().level.getGameTime() % 20L) / 20.0f * (float)Math.PI)) * 128.0f + 32.0f);
        int[] colors = beam.getRGB();
        Matrix4f positionMatrix = matrixStack.last().pose();
        double len = startPos.distanceTo(endPos);
        float xn = (float)((endPos.x - startPos.x) / len);
        float yn = (float)((endPos.y - startPos.y) / len);
        float zn = (float)((endPos.z - startPos.z) / len);
        VertexConsumer builder = buffer.getBuffer(ModRenderTypes.BEAM_LINE_THICK);
        ClientUtil.posF(builder, positionMatrix, startPos).color(colors[0], colors[1], colors[2], alpha).normal(matrixStack.last().normal(), xn, yn, zn).endVertex();
        ClientUtil.posF(builder, positionMatrix, endPos).color(colors[0], colors[1], colors[2], alpha).normal(matrixStack.last().normal(), xn, yn, zn).endVertex();
        VertexConsumer builder2 = buffer.getBuffer(ModRenderTypes.BEAM_LINE_THIN);
        ClientUtil.posF(builder2, positionMatrix, startPos).color(colors[0], colors[1], colors[2], 192).normal(matrixStack.last().normal(), xn, yn, zn).endVertex();
        ClientUtil.posF(builder2, positionMatrix, endPos).color(colors[0], colors[1], colors[2], 192).normal(matrixStack.last().normal(), xn, yn, zn).endVertex();
    }
}

