/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.config;

import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.config.ClientConfig;
import me.desht.modularrouters.config.CommonConfig;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHolder {
    public static ClientConfig client;
    public static CommonConfig common;
    private static ModConfigSpec configCommonSpec;
    private static ModConfigSpec configClientSpec;

    public static void init(IEventBus modBus) {
        Pair spec1 = new ModConfigSpec.Builder().configure(ClientConfig::new);
        client = (ClientConfig)spec1.getLeft();
        configClientSpec = (ModConfigSpec)spec1.getRight();
        Pair spec2 = new ModConfigSpec.Builder().configure(CommonConfig::new);
        common = (CommonConfig)spec2.getLeft();
        configCommonSpec = (ModConfigSpec)spec2.getRight();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)configCommonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)configClientSpec);
        modBus.addListener(ConfigHolder::onConfigChanged);
    }

    private static void onConfigChanged(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == configClientSpec) {
            ConfigHolder.refreshClient();
        } else if (config.getSpec() == configCommonSpec) {
            ConfigHolder.refreshCommon();
        }
    }

    static void refreshClient() {
    }

    static void refreshCommon() {
        ModularRouters.clearDimensionBlacklist();
    }
}

