/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.Validate;

public class AugmentHandler
extends ItemStackHandler {
    private final ItemStack holderStack;
    private final ModularRouterBlockEntity router;

    public AugmentHandler(ItemStack holderStack, ModularRouterBlockEntity router) {
        super(4);
        this.router = router;
        Validate.isTrue((boolean)(holderStack.getItem() instanceof ModuleItem), (String)"holder stack must be a module!", (Object[])new Object[0]);
        this.holderStack = holderStack;
        this.deserializeNBT(ModuleHelper.validateNBT(holderStack).getCompound("Augments"));
    }

    public ItemStack getHolderStack() {
        return this.holderStack;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof AugmentItem)) {
            return false;
        }
        AugmentItem augment = (AugmentItem)item;
        if (augment.getMaxAugments((ModuleItem)this.holderStack.getItem()) == 0) {
            return false;
        }
        for (int i = 0; i < this.getSlots(); ++i) {
            if (slot == i || stack.getItem() != this.getStackInSlot(i).getItem()) continue;
            return false;
        }
        return true;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof AugmentItem) {
            AugmentItem augment = (AugmentItem)item;
            return augment.getMaxAugments((ModuleItem)this.holderStack.getItem());
        }
        return 0;
    }

    protected void onContentsChanged(int slot) {
        this.save();
    }

    private void save() {
        ModuleHelper.validateNBTForWriting(this.holderStack).put("Augments", (Tag)this.serializeNBT());
        if (this.router != null) {
            this.router.recompileNeeded(1);
        }
    }
}

