/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.handler.GhostItemHandler;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public abstract class BaseModuleHandler
extends GhostItemHandler {
    private final ItemStack holderStack;
    protected final ModularRouterBlockEntity router;
    private final String tagName;
    private boolean autoSave = true;

    public BaseModuleHandler(ItemStack holderStack, ModularRouterBlockEntity router, int size, String tagName) {
        super(size);
        this.holderStack = holderStack;
        this.router = router;
        this.tagName = tagName;
        this.deserializeNBT(ModuleHelper.validateNBT(holderStack).getCompound(tagName));
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public ItemStack getHolderStack() {
        return this.holderStack;
    }

    protected void onContentsChanged(int slot) {
        if (this.autoSave) {
            this.save();
            if (this.router != null) {
                this.router.recompileNeeded(1);
            }
        }
    }

    public static int getFilterSize(ItemStack holderStack, String tagName) {
        CompoundTag tag = holderStack.getTagElement("modularrouters");
        if (tag != null && tag.contains(tagName)) {
            ModuleFilterHandler handler = new ModuleFilterHandler(holderStack, null);
            int n = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).isEmpty()) continue;
                ++n;
            }
            return n;
        }
        return 0;
    }

    public void save() {
        ModuleHelper.validateNBTForWriting(this.holderStack).put(this.tagName, (Tag)this.serializeNBT());
    }

    public static class ModuleFilterHandler
    extends BaseModuleHandler {
        public ModuleFilterHandler(ItemStack holderStack, @Nullable ModularRouterBlockEntity router) {
            super(holderStack, router, 9, "ModuleFilter");
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return ((ModuleItem)this.getHolderStack().getItem()).isItemValidForFilter(stack);
        }
    }

    public static class BulkFilterHandler
    extends BaseModuleHandler {
        private final ItemStack moduleStack;
        private final int filterSlot;
        private final boolean shouldSave;

        public BulkFilterHandler(ItemStack holderStack, @Nullable ModularRouterBlockEntity router) {
            this(holderStack, router, ItemStack.EMPTY, 0, true);
        }

        public BulkFilterHandler(ItemStack holderStack, ModularRouterBlockEntity router, ItemStack moduleStack, int filterSlot, boolean shouldSave) {
            super(holderStack, router, 54, "ModuleFilter");
            this.moduleStack = moduleStack;
            this.filterSlot = filterSlot;
            this.shouldSave = shouldSave;
        }

        @Override
        public void save() {
            if (this.shouldSave) {
                super.save();
                if (!this.moduleStack.isEmpty()) {
                    ModuleFilterHandler h = new ModuleFilterHandler(this.moduleStack, this.router);
                    h.setStackInSlot(this.filterSlot, this.getHolderStack());
                    h.save();
                }
            }
        }
    }
}

