/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModBlocks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BufferHandler
extends ItemStackHandler {
    private final ModularRouterBlockEntity router;
    private IEnergyStorage energyStorage;
    private IFluidHandlerItem fluidHandler;

    public BufferHandler(ModularRouterBlockEntity router) {
        super(router.getBufferSlotCount());
        this.router = router;
        this.setupFluidAndEnergyCaps();
    }

    public void onContentsChanged(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        IFluidHandlerItem newFluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        IEnergyStorage newEnergyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (newFluidHandler != this.fluidHandler || newEnergyStorage != this.energyStorage) {
            this.fluidHandler = newFluidHandler;
            this.energyStorage = newEnergyStorage;
            this.router.invalidateCapabilities();
            this.router.nonNullLevel().updateNeighborsAt(this.router.getBlockPos(), (Block)ModBlocks.MODULAR_ROUTER.get());
        }
        this.router.setChanged();
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.setupFluidAndEnergyCaps();
    }

    public IFluidHandlerItem getFluidHandler() {
        return this.fluidHandler;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    private void setupFluidAndEnergyCaps() {
        ItemStack stack = this.getStackInSlot(0);
        this.fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        this.energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
    }
}

