/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.event;

import me.desht.modularrouters.block.TemplateFrameBlock;
import me.desht.modularrouters.container.handler.AugmentHandler;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.item.IPlayerOwned;
import me.desht.modularrouters.item.module.ModuleItem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="modularrouters")
public class MiscEventHandler {
    @SubscribeEvent
    public static void onDigSpeedCheck(PlayerEvent.BreakSpeed event) {
        if (event.getState().getBlock() instanceof TemplateFrameBlock) {
            event.getPosition().flatMap(pos -> event.getEntity().level().getBlockEntity(pos, ModBlockEntities.TEMPLATE_FRAME.get())).ifPresent(te -> {
                if (te.getCamouflage() != null && te.extendedMimic()) {
                    event.setNewSpeed(event.getEntity().getDigSpeed(te.getCamouflage(), null));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack stack = event.getCrafting();
        Item item = event.getCrafting().getItem();
        if (item instanceof IPlayerOwned) {
            IPlayerOwned playerOwned = (IPlayerOwned)item;
            playerOwned.setOwner(stack, event.getEntity());
        } else if (stack.getItem() instanceof ModuleItem) {
            ItemStack moduleStack = ItemStack.EMPTY;
            for (int i = 0; i < event.getInventory().getContainerSize(); ++i) {
                ItemStack s = event.getInventory().getItem(i);
                if (s.isEmpty()) continue;
                if (s.getItem() != event.getCrafting().getItem()) break;
                moduleStack = s;
            }
            if (!moduleStack.isEmpty()) {
                AugmentHandler h = new AugmentHandler(moduleStack, null);
                for (int i = 0; i < h.getSlots(); ++i) {
                    ItemHandlerHelper.giveItemToPlayer((Player)event.getEntity(), (ItemStack)h.getStackInSlot(i));
                }
            }
        }
    }
}

