/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import me.desht.modularrouters.util.TranslatableEnum;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;

public class XPCollection {
    private static final Set<XPCollectionType> AVAILABLE = EnumSet.noneOf(XPCollectionType.class);
    private static final Map<XPCollectionType, ItemStack> ICONS = new EnumMap<XPCollectionType, ItemStack>(XPCollectionType.class);

    public static void detectXPTypes() {
        ICONS.clear();
        for (XPCollectionType type : XPCollectionType.values()) {
            if (XPCollection.getIconForResource(type).isEmpty()) continue;
            AVAILABLE.add(type);
        }
    }

    private static ItemStack getIconForResource(XPCollectionType type) {
        if (!ICONS.containsKey(type)) {
            if (type.isSolid()) {
                ICONS.put(type, new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(type.getRegistryName())));
            } else {
                Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(type.getRegistryName());
                ICONS.put(type, fluid == Fluids.EMPTY ? ItemStack.EMPTY : FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000)));
            }
        }
        return ICONS.getOrDefault(type, ItemStack.EMPTY);
    }

    public static XPCollectionType getXPType(int type) {
        XPCollectionType xpType = XPCollectionType.values()[type];
        if (!xpType.isAvailable()) {
            xpType = XPCollectionType.BOTTLE_O_ENCHANTING;
        }
        return xpType;
    }

    public static enum XPCollectionType implements TranslatableEnum
    {
        SOLIDIFIED_EXPERIENCE(true, 8, "actuallyadditions:item_solidified_experience"),
        BOTTLE_O_ENCHANTING(true, 7, "minecraft:experience_bottle"),
        NUGGET_OF_EXPERIENCE(true, 7, "create:experience_nugget"),
        MEMORY_ESSENCE(false, 20, "pneumaticcraft:memory_essence"),
        CYCLIC_XP_JUICE(false, 20, "cyclic:xpjuice"),
        IF_ESSENCE(false, 20, "industrialforegoing:essence"),
        SOPHISTICATED_EXPERIENCE(false, 9, "sophisticatedcore:xp_still");

        private final boolean solid;
        private final int xpRatio;
        private final ResourceLocation registryName;

        private XPCollectionType(boolean solid, int xpRatio, String registryName) {
            this.solid = solid;
            this.xpRatio = xpRatio;
            this.registryName = new ResourceLocation(registryName);
        }

        public int getXpRatio() {
            return this.xpRatio;
        }

        public ResourceLocation getRegistryName() {
            return this.registryName;
        }

        public boolean isSolid() {
            return this.solid;
        }

        public Fluid getFluid() {
            return (Fluid)BuiltInRegistries.FLUID.get(this.registryName);
        }

        public String getModId() {
            return this.registryName.getNamespace();
        }

        public boolean isAvailable() {
            return AVAILABLE.contains(this);
        }

        public ItemStack getIcon() {
            return XPCollection.getIconForResource(this);
        }

        public Component getDisplayName() {
            return XPCollection.getIconForResource(this).getHoverName();
        }

        @Override
        public String getTranslationKey() {
            return null;
        }
    }
}

