/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration.waila;

import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class RouterComponentProvider
implements IBlockComponentProvider {
    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        CompoundTag data = blockAccessor.getServerData();
        if (blockAccessor.getBlockEntity() instanceof ModularRouterBlockEntity) {
            if (data.getBoolean("Denied")) {
                iTooltip.add((Component)ClientUtil.xlate("modularrouters.chatText.security.accessDenied", new Object[0]).withStyle(ChatFormatting.RED));
            } else {
                CompoundTag upgrades;
                if (data.getInt("ModuleCount") > 0) {
                    iTooltip.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.moduleCount", data.getInt("ModuleCount")));
                }
                if (!(upgrades = data.getCompound("Upgrades")).isEmpty()) {
                    iTooltip.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.upgrades", new Object[0]));
                    for (String k : upgrades.getAllKeys()) {
                        iTooltip.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.upgradeCount", upgrades.getInt(k), ClientUtil.xlate(k, new Object[0])));
                    }
                }
                RouterRedstoneBehaviour rrb = RouterRedstoneBehaviour.values()[data.getInt("RedstoneMode")];
                iTooltip.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.redstone.label", new Object[0]).append(": " + ChatFormatting.AQUA).append((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.redstone." + rrb, new Object[0])));
                if (data.getBoolean("EcoMode")) {
                    iTooltip.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.ecoMode", new Object[0]).withStyle(ChatFormatting.GREEN));
                }
            }
        }
    }

    public ResourceLocation getUid() {
        return MiscUtil.RL("router");
    }
}

