/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface IPlayerOwned {
    public static final String NBT_OWNER = "Owner";

    default public Optional<GameProfile> getOwnerProfile(ItemStack stack) {
        if (!stack.hasTag() || !Objects.requireNonNull(stack.getTag()).contains(NBT_OWNER, 9)) {
            return Optional.empty();
        }
        ListTag l = stack.getTag().getList(NBT_OWNER, 8);
        return Optional.of(new GameProfile(UUID.fromString(l.getString(1)), l.getString(0)));
    }

    default public void setOwner(ItemStack stack, Player player) {
        CompoundTag compound = stack.getOrCreateTag();
        ListTag owner = new ListTag();
        owner.add((Object)StringTag.valueOf((String)player.getGameProfile().getName()));
        owner.add((Object)StringTag.valueOf((String)player.getGameProfile().getId().toString()));
        compound.put(NBT_OWNER, (Tag)owner);
        stack.setTag(compound);
    }
}

