/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import java.util.List;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.compiled.CompiledActivatorModule;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class ActivatorModule
extends ModuleItem {
    private static final TintColor TINT_COLOR = new TintColor(255, 255, 195);

    public ActivatorModule() {
        super(ModItems.defaultProps(), CompiledActivatorModule::new);
    }

    @Override
    public void addSettingsInformation(ItemStack stack, List<Component> list) {
        super.addSettingsInformation(stack, list);
        CompiledActivatorModule cam = new CompiledActivatorModule(null, stack);
        list.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.action", new Object[0]).append(": ").withStyle(ChatFormatting.YELLOW).append((Component)ClientUtil.xlate("modularrouters.itemText.activator.action." + cam.getActionType(), new Object[0]).withStyle(ChatFormatting.AQUA)));
        if (!cam.getActionType().isEntityTarget()) {
            list.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.lookDirection", new Object[0]).append(": ").withStyle(ChatFormatting.YELLOW).append((Component)ClientUtil.xlate("modularrouters.itemText.activator.direction." + cam.getLookDirection(), new Object[0]).withStyle(ChatFormatting.AQUA)));
        } else {
            list.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.entityMode", new Object[0]).append(": ").withStyle(ChatFormatting.YELLOW).append((Component)ClientUtil.xlate("modularrouters.itemText.activator.entityMode." + cam.getEntityMode(), new Object[0]).withStyle(ChatFormatting.AQUA)));
        }
        if (cam.isSneaking()) {
            list.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.sneak", new Object[0]).withStyle(ChatFormatting.YELLOW));
        }
    }

    @Override
    public int getEnergyCost(ItemStack stack) {
        CompiledActivatorModule cam = new CompiledActivatorModule(null, stack);
        return cam.getActionType() == CompiledActivatorModule.ActionType.ATTACK_ENTITY ? (Integer)ConfigHolder.common.energyCosts.activatorModuleEnergyCostAttack.get() : (Integer)ConfigHolder.common.energyCosts.activatorModuleEnergyCost.get();
    }

    @Override
    public MenuType<? extends ModuleMenu> getMenuType() {
        return ModMenuTypes.ACTIVATOR_MENU.get();
    }

    @Override
    public TintColor getItemTint() {
        return TINT_COLOR;
    }
}

