/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.item.module.SenderModule2;
import me.desht.modularrouters.item.module.TargetedModule;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledDistributorModule;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class DistributorModule
extends SenderModule2 {
    private static final TintColor TINT_COLOR = new TintColor(240, 240, 60);

    public DistributorModule() {
        super(CompiledDistributorModule::new);
    }

    @Override
    public void addSettingsInformation(ItemStack itemstack, List<Component> list) {
        super.addSettingsInformation(itemstack, list);
        CompiledDistributorModule cdm = new CompiledDistributorModule(null, itemstack);
        list.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.distributor.strategy", new Object[0]).withStyle(ChatFormatting.YELLOW).append(": ").withStyle(ChatFormatting.YELLOW).append((Component)ClientUtil.xlate(cdm.getDistributionStrategy().getTranslationKey(), new Object[0])).withStyle(ChatFormatting.AQUA));
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.fluid.direction." + (cdm.isPulling() ? "IN" : "OUT"), new Object[0]).withStyle(ChatFormatting.YELLOW));
    }

    @Override
    public MenuType<? extends ModuleMenu> getMenuType() {
        return ModMenuTypes.DISTRIBUTOR_MENU.get();
    }

    @Override
    public List<ModuleTarget> getStoredPositions(@Nonnull ItemStack stack) {
        return ImmutableList.copyOf(TargetedModule.getTargets(stack, false));
    }

    @Override
    public TintColor getItemTint() {
        return TINT_COLOR;
    }

    @Override
    protected int getMaxTargets() {
        return 8;
    }

    @Override
    public int getRenderColor(int index) {
        return -2135883888;
    }

    @Override
    public int getEnergyCost(ItemStack stack) {
        return (Integer)ConfigHolder.common.energyCosts.distributorModuleEnergyCost.get();
    }
}

