/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.ClientSetup;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.container.RouterMenu;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.item.MRBaseItem;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.IPickaxeUser;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.SimpleItemMatcher;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.ModuleHelper;
import me.desht.modularrouters.util.TranslatableEnum;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class ModuleItem
extends MRBaseItem
implements ModItems.ITintable {
    final BiFunction<ModularRouterBlockEntity, ItemStack, ? extends CompiledModule> compiler;

    public ModuleItem(Item.Properties props, BiFunction<ModularRouterBlockEntity, ItemStack, ? extends CompiledModule> compiler) {
        super(props);
        this.compiler = compiler;
    }

    public final CompiledModule compile(ModularRouterBlockEntity router, ItemStack stack) {
        return this.compiler.apply(router, stack);
    }

    @Override
    public abstract TintColor getItemTint();

    public boolean isDirectional() {
        return true;
    }

    public boolean isOmniDirectional() {
        return false;
    }

    public boolean isFluidModule() {
        return false;
    }

    ModuleMenu createContainer(int windowId, Inventory invPlayer, MFLocator loc) {
        return new ModuleMenu(this.getMenuType(), windowId, invPlayer, loc);
    }

    public MenuType<? extends ModuleMenu> getMenuType() {
        return ModMenuTypes.BASE_MODULE_MENU.get();
    }

    public boolean isItemValidForFilter(ItemStack stack) {
        return true;
    }

    @Nonnull
    public IItemMatcher getFilterItemMatcher(ItemStack stack) {
        return new SimpleItemMatcher(stack);
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, world, list, flag);
        if (ClientUtil.getHoveredSlot() instanceof RouterMenu.InstalledModuleSlot && !ClientUtil.isKeyDown(ClientSetup.keybindModuleInfo)) {
            MutableComponent key = ClientSetup.keybindConfigure.getKey().getDisplayName().copy().withStyle(ChatFormatting.DARK_AQUA);
            MutableComponent middleClick = Component.literal((String)"Middle-Click").withStyle(ChatFormatting.DARK_AQUA);
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.configureHint", key, middleClick).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    @Override
    protected void addExtraInformation(ItemStack stack, List<Component> list) {
        this.addSettingsInformation(stack, list);
        this.addAugmentInformation(stack, list);
    }

    protected void addSettingsInformation(ItemStack itemstack, List<Component> list) {
        int energy;
        Termination termination;
        ModuleItem col;
        if (this.isDirectional()) {
            RelativeDirection dir = ModuleHelper.getRelativeDirection(itemstack);
            MutableComponent itc = ClientUtil.xlate((String)(this.isOmniDirectional() && dir == RelativeDirection.NONE ? "modularrouters.guiText.tooltip.allDirections" : "modularrouters.guiText.tooltip." + dir.toString()), new Object[0]);
            list.add((Component)ClientUtil.xlate("modularrouters.guiText.label.direction", new Object[0]).withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)": ")).append((Component)itc.withStyle(ChatFormatting.AQUA)));
        }
        this.addFilterInformation(itemstack, list);
        MutableComponent flags = this.formatFlag("IGNORE_DAMAGE", ModuleHelper.ignoreDamage(itemstack)).append(" | ").append((Component)this.formatFlag("IGNORE_NBT", ModuleHelper.ignoreNBT(itemstack))).append(" | ").append((Component)this.formatFlag("IGNORE_TAGS", ModuleHelper.ignoreTags(itemstack)));
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.flags", new Object[0]).withStyle(ChatFormatting.YELLOW).append(": ").append((Component)flags));
        boolean matchAll = ModuleHelper.isMatchAll(itemstack);
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.match", new Object[0]).withStyle(ChatFormatting.YELLOW).append(": ").append((Component)ClientUtil.xlate("modularrouters.itemText.misc." + (matchAll ? "matchAll" : "matchAny"), new Object[0]).withStyle(ChatFormatting.AQUA)));
        ModuleItem moduleItem = this;
        if (moduleItem instanceof IRangedModule) {
            IRangedModule rm = (IRangedModule)((Object)moduleItem);
            int curRange = rm.getCurrentRange(itemstack);
            col = curRange > rm.getBaseRange() ? ChatFormatting.GREEN : (curRange < rm.getBaseRange() ? ChatFormatting.RED : ChatFormatting.AQUA);
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.rangeInfo", ClientUtil.colorText(rm.getCurrentRange(itemstack), new ChatFormatting[]{col}), ClientUtil.colorText(rm.getBaseRange(), ChatFormatting.AQUA), ClientUtil.colorText(rm.getHardMaxRange(), ChatFormatting.AQUA)).withStyle(ChatFormatting.YELLOW));
        }
        if ((termination = ModuleHelper.getTermination(itemstack)) != Termination.NONE) {
            list.add((Component)ClientUtil.xlate(termination.getTranslationKey() + ".header", new Object[0]).withStyle(ChatFormatting.YELLOW));
        }
        if ((col = this) instanceof IPickaxeUser) {
            IPickaxeUser pickaxeUser = (IPickaxeUser)((Object)col);
            ItemStack pick = pickaxeUser.getPickaxe(itemstack);
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.breakerPick", new Object[0]).withStyle(ChatFormatting.YELLOW).append((Component)pick.getHoverName().plainCopy().withStyle(ChatFormatting.AQUA)));
            EnchantmentHelper.getEnchantments((ItemStack)pick).forEach((ench, level) -> list.add((Component)Component.literal((String)"\u25b6 ").append((Component)ench.getFullname(level.intValue()).plainCopy().withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.YELLOW)));
        }
        if ((energy = this.getEnergyCost(itemstack)) != 0) {
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.energyUsage", ClientUtil.colorText(energy, ChatFormatting.AQUA)).withStyle(ChatFormatting.YELLOW));
        }
    }

    public abstract int getEnergyCost(ItemStack var1);

    private void addAugmentInformation(ItemStack stack, List<Component> list) {
        AugmentItem.AugmentCounter c = new AugmentItem.AugmentCounter(stack);
        ArrayList toAdd = Lists.newArrayList();
        for (AugmentItem augment : c.getAugments()) {
            int n = c.getAugmentCount(augment);
            if (n <= 0) continue;
            ItemStack augmentStack = new ItemStack((ItemLike)augment);
            MutableComponent comp = Component.literal((String)" \u2022 ").withStyle(ChatFormatting.DARK_GREEN).append((Component)(n > 1 ? Component.literal((String)(n + " x ")).append(augmentStack.getHoverName()) : augmentStack.getHoverName())).append((Component)augment.getExtraInfo(n, stack).copy().withStyle(ChatFormatting.DARK_AQUA));
            toAdd.add(comp);
        }
        if (!toAdd.isEmpty()) {
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.augments", new Object[0]).withStyle(ChatFormatting.GREEN));
            list.addAll(toAdd);
        }
    }

    public MutableComponent getDirectionString(RelativeDirection dir) {
        return this.isOmniDirectional() && dir == RelativeDirection.NONE ? ClientUtil.xlate("modularrouters.guiText.tooltip.allDirections", new Object[0]) : ClientUtil.xlate("modularrouters.guiText.tooltip." + dir.toString(), new Object[0]);
    }

    private MutableComponent formatFlag(String key, boolean flag) {
        return ClientUtil.xlate("modularrouters.itemText.misc." + key, new Object[0]).withStyle(flag ? ChatFormatting.DARK_GRAY : ChatFormatting.AQUA);
    }

    protected Component getFilterItemDisplayName(ItemStack stack) {
        return stack.getHoverName();
    }

    protected MutableComponent itemListHeader(ItemStack itemstack) {
        return ClientUtil.xlate("modularrouters.itemText.misc." + (ModuleHelper.isBlacklist(itemstack) ? "blacklist" : "whitelist"), new Object[0]).withStyle(ChatFormatting.YELLOW);
    }

    private void addFilterInformation(ItemStack itemstack, List<Component> list) {
        ArrayList<MutableComponent> l2 = new ArrayList<MutableComponent>();
        BaseModuleHandler.ModuleFilterHandler filterHandler = new BaseModuleHandler.ModuleFilterHandler(itemstack, null);
        for (int i = 0; i < filterHandler.getSlots(); ++i) {
            ItemStack s = filterHandler.getStackInSlot(i);
            Item item = s.getItem();
            if (item instanceof SmartFilterItem) {
                SmartFilterItem sf = (SmartFilterItem)item;
                int size = sf.getSize(s);
                Object suffix = size > 0 ? " [" + size + "]" : "";
                l2.add(Component.literal((String)" \u2022 ").append((Component)s.getHoverName().plainCopy().append((String)suffix)).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
                continue;
            }
            if (s.isEmpty()) continue;
            l2.add(Component.literal((String)" \u2022 ").append((Component)this.getFilterItemDisplayName(s).plainCopy().withStyle(ChatFormatting.AQUA)));
        }
        if (l2.isEmpty()) {
            list.add((Component)this.itemListHeader(itemstack).withStyle(ChatFormatting.YELLOW).append(": ").append((Component)ClientUtil.xlate("modularrouters.itemText.misc.noItems", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC})));
        } else {
            list.add((Component)this.itemListHeader(itemstack).withStyle(ChatFormatting.YELLOW).append(": "));
            list.addAll(l2);
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isCrouching()) {
            if (!world.isClientSide) {
                MFLocator locator = MFLocator.heldModule(hand);
                player.openMenu((MenuProvider)new ModuleMenuProvider(player, locator), locator::writeBuf);
            }
        } else {
            return this.onSneakRightClick(stack, world, player, hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public boolean isFoil(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IPickaxeUser) {
            IPickaxeUser pickaxeUser = (IPickaxeUser)item;
            ItemStack pick = pickaxeUser.getPickaxe(stack);
            return !pick.isEmpty() && !EnchantmentHelper.getEnchantments((ItemStack)pick).isEmpty();
        }
        return false;
    }

    public String getRegulatorTranslationKey(ItemStack stack) {
        return "modularrouters.guiText.tooltip.regulator.label";
    }

    public InteractionResultHolder<ItemStack> onSneakRightClick(ItemStack stack, Level world, Player player, InteractionHand hand) {
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }

    public void doModuleValidation(ItemStack stack, ServerPlayer player) {
    }

    public static enum RelativeDirection {
        NONE(0, " "),
        DOWN(1, "\u25bc"),
        UP(2, "\u25b2"),
        LEFT(4, "\u25c0"),
        RIGHT(8, "\u25b6"),
        FRONT(16, "\u25a3"),
        BACK(32, "\u25a4");

        private final byte mask;
        private final String symbol;

        private RelativeDirection(int mask, String symbol) {
            this.mask = (byte)mask;
            this.symbol = symbol;
        }

        public Direction toAbsolute(Direction current) {
            return switch (this) {
                case UP -> Direction.UP;
                case DOWN -> Direction.DOWN;
                case LEFT -> current.getClockWise();
                case BACK -> current.getOpposite();
                case RIGHT -> current.getCounterClockWise();
                default -> current;
            };
        }

        public String getSymbol() {
            return this.symbol;
        }

        public byte getMask() {
            return this.mask;
        }

        public int getTextureX(boolean toggled) {
            return this.ordinal() * 32 + (toggled ? 16 : 0);
        }

        public int getTextureY() {
            return 48;
        }
    }

    public static enum Termination implements TranslatableEnum
    {
        NONE,
        RAN,
        NOT_RAN;


        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.tooltip.terminate." + this;
        }
    }

    public static class ModuleMenuProvider
    implements MenuProvider {
        private final MFLocator loc;
        private final ItemStack moduleStack;

        public ModuleMenuProvider(Player player, MFLocator loc) {
            this.loc = loc;
            this.moduleStack = loc.getModuleStack(player);
        }

        public Component getDisplayName() {
            return this.moduleStack.getHoverName();
        }

        @Nullable
        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
            return ((ModuleItem)this.moduleStack.getItem()).createContainer(windowId, playerInventory, this.loc);
        }
    }

    public static enum ModuleFlags {
        BLACKLIST(true, "F_blacklist"),
        IGNORE_DAMAGE(false, "F_ignoreDamage"),
        IGNORE_NBT(true, "F_ignoreNBT"),
        IGNORE_TAGS(true, "F_ignoreTags");

        private final boolean defaultValue;
        private final String name;

        private ModuleFlags(boolean defaultValue, String name) {
            this.defaultValue = defaultValue;
            this.name = name;
        }

        public boolean getDefaultValue() {
            return this.defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public int getTextureY() {
            return 32;
        }
    }
}

