/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import java.util.Comparator;
import java.util.List;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.AbstractSmartFilterMenu;
import me.desht.modularrouters.container.BulkItemFilterMenu;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.logic.filter.matchers.BulkItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.network.messages.FilterSettingsMessage;
import me.desht.modularrouters.network.messages.GuiSyncMessage;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.SetofItemStack;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class BulkItemFilter
extends SmartFilterItem {
    public static final int FILTER_SIZE = 54;

    @Override
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        Filter.Flags flags = moduleStack.isEmpty() ? Filter.Flags.DEFAULT_FLAGS : new Filter.Flags(moduleStack);
        SetofItemStack stacks = BulkItemFilter.getFilterItems(filterStack, flags);
        return new BulkItemMatcher(stacks, flags);
    }

    private static SetofItemStack getFilterItems(ItemStack filterStack, Filter.Flags flags) {
        if (filterStack.hasTag()) {
            BaseModuleHandler.BulkFilterHandler handler = new BaseModuleHandler.BulkFilterHandler(filterStack, null);
            return SetofItemStack.fromItemHandler((IItemHandler)handler, flags);
        }
        return new SetofItemStack(Filter.Flags.DEFAULT_FLAGS);
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, List<Component> list) {
        super.addExtraInformation(itemstack, list);
        this.addCountInfo(list, this.getSize(itemstack));
    }

    @Override
    public AbstractSmartFilterMenu createMenu(int windowId, Inventory invPlayer, MFLocator loc) {
        return new BulkItemFilterMenu(windowId, invPlayer, loc);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        Player player = ctx.getPlayer();
        ItemStack stack = ctx.getItemInHand();
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (player != null && player.isShiftKeyDown()) {
            return InventoryUtils.getInventory(world, ctx.getClickedPos(), ctx.getClickedFace()).map(handler -> {
                int nAdded = this.mergeInventory(stack, (IItemHandler)handler);
                player.displayClientMessage((Component)Component.translatable((String)"modularrouters.chatText.misc.inventoryMerged", (Object[])new Object[]{nAdded, stack.getHoverName()}), false);
                world.playSound(null, ctx.getClickedPos(), ModSounds.SUCCESS.get(), SoundSource.MASTER, ((Double)ConfigHolder.client.sound.bleepVolume.get()).floatValue(), 1.0f);
                return InteractionResult.SUCCESS;
            }).orElse(super.useOn(ctx));
        }
        return InteractionResult.PASS;
    }

    @Override
    public GuiSyncMessage onReceiveSettingsMessage(Player player, FilterSettingsMessage message, ItemStack filterStack, ItemStack moduleStack) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof BulkItemFilterMenu) {
            BulkItemFilterMenu con = (BulkItemFilterMenu)abstractContainerMenu;
            Filter.Flags flags = moduleStack.isEmpty() ? Filter.Flags.DEFAULT_FLAGS : new Filter.Flags(moduleStack);
            switch (message.op()) {
                case CLEAR_ALL: {
                    con.clearSlots();
                    break;
                }
                case MERGE: {
                    message.getTargetInventory().ifPresent(h -> con.mergeInventory((IItemHandler)h, flags, false));
                    break;
                }
                case LOAD: {
                    message.getTargetInventory().ifPresent(h -> con.mergeInventory((IItemHandler)h, flags, true));
                    break;
                }
                default: {
                    ModularRouters.LOGGER.warn("received unexpected message type " + message.op() + " for " + filterStack);
                }
            }
        }
        return null;
    }

    @Override
    public int getSize(ItemStack filterStack) {
        return BaseModuleHandler.getFilterSize(filterStack, "ModuleFilter");
    }

    private int mergeInventory(ItemStack filterStack, IItemHandler srcInventory) {
        SetofItemStack stacks = BulkItemFilter.getFilterItems(filterStack, Filter.Flags.DEFAULT_FLAGS);
        int origSize = stacks.size();
        for (int i = 0; i < srcInventory.getSlots() && stacks.size() < 54; ++i) {
            ItemStack stack = srcInventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            stacks.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        }
        BaseModuleHandler.BulkFilterHandler handler = new BaseModuleHandler.BulkFilterHandler(filterStack, null);
        int slot = 0;
        Comparator comp = (o1, o2) -> o1.getHoverName().toString().compareTo(o2.getHoverName().getString());
        for (ItemStack stack : stacks.stream().sorted(comp).toList()) {
            handler.setStackInSlot(slot++, stack);
        }
        handler.save();
        return stacks.size() - origSize;
    }
}

