/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.InspectionMatcher;
import me.desht.modularrouters.network.messages.FilterSettingsMessage;
import me.desht.modularrouters.network.messages.GuiSyncMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InspectionFilter
extends SmartFilterItem {
    private static final String NBT_MATCH_ALL = "MatchAll";
    private static final String NBT_ITEMS = "Items";
    public static final String NBT_COMPARISON = "Comparison";
    public static final int MAX_SIZE = 6;

    @Override
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        return new InspectionMatcher(InspectionFilter.getComparisonList(filterStack));
    }

    @Override
    public boolean hasMenu() {
        return false;
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, List<Component> list) {
        super.addExtraInformation(itemstack, list);
        InspectionMatcher.ComparisonList comparisonList = InspectionFilter.getComparisonList(itemstack);
        if (!comparisonList.items.isEmpty()) {
            list.add((Component)ClientUtil.xlate("modularrouters.guiText.label.matchAll." + comparisonList.isMatchAll(), new Object[0]).append(":").withStyle(ChatFormatting.YELLOW));
            for (InspectionMatcher.Comparison c : comparisonList.items) {
                list.add((Component)Component.literal((String)"\u2022 ").append((Component)c.asLocalizedText().withStyle(ChatFormatting.AQUA)));
            }
        }
    }

    public static InspectionMatcher.ComparisonList getComparisonList(ItemStack filterStack) {
        CompoundTag compound = filterStack.getTagElement("modularrouters");
        if (compound != null) {
            boolean matchAll = compound.getBoolean(NBT_MATCH_ALL);
            ArrayList l = Lists.newArrayList();
            ListTag items = compound.getList(NBT_ITEMS, 8);
            for (int i = 0; i < items.size(); ++i) {
                l.add(InspectionMatcher.Comparison.fromString(items.getString(i)));
            }
            return new InspectionMatcher.ComparisonList(l, matchAll);
        }
        return new InspectionMatcher.ComparisonList(Lists.newArrayList(), false);
    }

    private void setComparisonList(ItemStack filterStack, InspectionMatcher.ComparisonList comparisonList) {
        ListTag l = comparisonList.items.stream().map(comp -> StringTag.valueOf((String)comp.toString())).collect(Collectors.toCollection(ListTag::new));
        CompoundTag compound = filterStack.getOrCreateTagElement("modularrouters");
        compound.putBoolean(NBT_MATCH_ALL, comparisonList.isMatchAll());
        compound.put(NBT_ITEMS, (Tag)l);
    }

    @Override
    public GuiSyncMessage onReceiveSettingsMessage(Player player, FilterSettingsMessage message, ItemStack filterStack, ItemStack moduleStack) {
        InspectionMatcher.ComparisonList comparisonList = InspectionFilter.getComparisonList(filterStack);
        switch (message.op()) {
            case ADD_STRING: {
                if (comparisonList.items.size() >= 6) break;
                InspectionMatcher.Comparison c = InspectionMatcher.Comparison.fromString(message.payload().getString(NBT_COMPARISON));
                comparisonList.items.add(c);
                this.setComparisonList(filterStack, comparisonList);
                return new GuiSyncMessage(filterStack);
            }
            case REMOVE_AT: {
                int pos = message.payload().getInt("Pos");
                if (pos < 0 || pos >= comparisonList.items.size()) break;
                comparisonList.items.remove(pos);
                this.setComparisonList(filterStack, comparisonList);
                return new GuiSyncMessage(filterStack);
            }
            case ANY_ALL_FLAG: {
                comparisonList.setMatchAll(message.payload().getBoolean(NBT_MATCH_ALL));
                this.setComparisonList(filterStack, comparisonList);
                return new GuiSyncMessage(filterStack);
            }
        }
        return null;
    }

    @Override
    public int getSize(ItemStack filterStack) {
        return 0;
    }
}

