/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.container.AbstractSmartFilterMenu;
import me.desht.modularrouters.container.TagFilterMenu;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.TagMatcher;
import me.desht.modularrouters.network.messages.FilterSettingsMessage;
import me.desht.modularrouters.network.messages.GuiSyncMessage;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagFilter
extends SmartFilterItem {
    private static final int MAX_SIZE = 6;
    private static final String NBT_TAGS = "Tags";

    public static List<TagKey<Item>> getTagList(ItemStack filterStack) {
        CompoundTag tag = filterStack.getTagElement("modularrouters");
        if (tag != null) {
            return tag.getList(NBT_TAGS, 8).stream().map(strTag -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation(strTag.getAsString()))).toList();
        }
        return List.of();
    }

    public static void setTagList(ItemStack filterStack, List<TagKey<Item>> tags) {
        ListTag list = tags.stream().map(tag -> StringTag.valueOf((String)tag.location().toString())).collect(Collectors.toCollection(ListTag::new));
        filterStack.getOrCreateTagElement("modularrouters").put(NBT_TAGS, (Tag)list);
    }

    @Override
    @NotNull
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        return new TagMatcher(TagFilter.getTagList(filterStack));
    }

    @Override
    public void addExtraInformation(ItemStack stack, List<Component> list) {
        super.addExtraInformation(stack, list);
        if (stack.getTagElement("modularrouters") != null) {
            List<TagKey<Item>> l = TagFilter.getTagList(stack);
            this.addCountInfo(list, l.size());
            list.addAll(l.stream().map(s -> " \u2022 " + ChatFormatting.AQUA + s.location()).map(Component::literal).toList());
        } else {
            this.addCountInfo(list, 0);
        }
    }

    @Override
    @Nullable
    public GuiSyncMessage onReceiveSettingsMessage(Player player, FilterSettingsMessage message, ItemStack filterStack, ItemStack moduleStack) {
        switch (message.op()) {
            case ADD_STRING: {
                TagKey tag;
                ArrayList<TagKey<Item>> tagList = new ArrayList<TagKey<Item>>(TagFilter.getTagList(filterStack));
                String t = message.payload().getString("Tag");
                if (tagList.size() >= 6 || !ResourceLocation.isValidResourceLocation((String)t) || tagList.contains(tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation(t)))) break;
                tagList.add((TagKey<Item>)tag);
                TagFilter.setTagList(filterStack, tagList);
                return new GuiSyncMessage(filterStack);
            }
            case REMOVE_AT: {
                int pos = message.payload().getInt("Pos");
                ArrayList<TagKey<Item>> tagList = new ArrayList<TagKey<Item>>(TagFilter.getTagList(filterStack));
                if (pos < 0 || pos >= tagList.size()) break;
                tagList.remove(pos);
                TagFilter.setTagList(filterStack, tagList);
                return new GuiSyncMessage(filterStack);
            }
            default: {
                ModularRouters.LOGGER.warn("received unexpected message type " + message.op() + " for " + filterStack);
            }
        }
        return null;
    }

    @Override
    public int getSize(ItemStack filterStack) {
        CompoundTag tag = filterStack.getTagElement("modularrouters");
        return tag != null ? tag.getList(NBT_TAGS, 8).size() : 0;
    }

    @Override
    public AbstractSmartFilterMenu createMenu(int windowId, Inventory invPlayer, MFLocator loc) {
        return new TagFilterMenu(windowId, invPlayer, loc);
    }
}

