/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.upgrade;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.IPlayerOwned;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SecurityUpgrade
extends UpgradeItem
implements IPlayerOwned {
    private static final String NBT_PLAYERS = "Players";
    private static final int MAX_PLAYERS = 6;

    @Override
    public void addExtraInformation(ItemStack itemstack, List<Component> list) {
        String owner = this.getOwnerProfile(itemstack).map(GameProfile::getName).orElse("-");
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.security.owner", ChatFormatting.AQUA + owner));
        Set<String> names = SecurityUpgrade.getPlayerNames(itemstack);
        if (!names.isEmpty()) {
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.security.count", names.size(), 6));
            list.addAll(names.stream().map(name -> " \u2022 " + ChatFormatting.YELLOW + name).sorted().map(Component::literal).toList());
        }
    }

    @Override
    public void onCompiled(ItemStack stack, ModularRouterBlockEntity router) {
        super.onCompiled(stack, router);
        router.addPermittedIds(this.getPlayerIDs(stack));
    }

    @Override
    public TintColor getItemTint() {
        return new TintColor(64, 64, 255);
    }

    private Set<UUID> getPlayerIDs(ItemStack stack) {
        CompoundTag compound = stack.getTag();
        if (compound == null) {
            return Set.of();
        }
        return this.getOwnerProfile(stack).map(profile -> {
            HashSet res = Sets.newHashSet();
            res.add(profile.getId());
            if (compound.contains(NBT_PLAYERS)) {
                CompoundTag p = compound.getCompound(NBT_PLAYERS);
                res.addAll(p.getAllKeys().stream().map(UUID::fromString).toList());
            }
            return res;
        }).orElse(Set.of());
    }

    private static Set<String> getPlayerNames(ItemStack stack) {
        CompoundTag compound = stack.getTag();
        if (compound != null && compound.contains(NBT_PLAYERS)) {
            CompoundTag p = compound.getCompound(NBT_PLAYERS);
            return p.getAllKeys().stream().map(arg_0 -> ((CompoundTag)p).getString(arg_0)).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return Collections.emptySet();
    }

    private static Result addPlayer(ItemStack stack, String id, String name) {
        CompoundTag compound = stack.getTag();
        if (compound != null) {
            CompoundTag p;
            if (!compound.contains(NBT_PLAYERS)) {
                compound.put(NBT_PLAYERS, (Tag)new CompoundTag());
            }
            if ((p = compound.getCompound(NBT_PLAYERS)).contains(id)) {
                return Result.ALREADY_ADDED;
            }
            if (p.size() >= 6) {
                return Result.FULL;
            }
            p.putString(id, name);
            return Result.ADDED;
        }
        return Result.ERROR;
    }

    private static Result removePlayer(ItemStack stack, String id) {
        CompoundTag compound = stack.getTag();
        if (compound != null) {
            CompoundTag p;
            if (!compound.contains(NBT_PLAYERS)) {
                compound.put(NBT_PLAYERS, (Tag)new CompoundTag());
            }
            if ((p = compound.getCompound(NBT_PLAYERS)).contains(id)) {
                p.remove(id);
                return Result.REMOVED;
            }
            return Result.NOT_PRESENT;
        }
        return Result.ERROR;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.getCommandSenderWorld().isClientSide && player.isSteppingCarefully()) {
            this.setOwner(stack, player);
            player.displayClientMessage((Component)Component.translatable((String)"modularrouters.itemText.security.owner", (Object[])new Object[]{player.getDisplayName().getString()}), false);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof Player) {
            Result res;
            Player targetPlayer = (Player)entity;
            String id = targetPlayer.getUUID().toString();
            String name = targetPlayer.getDisplayName().toString();
            Result result = res = player.isSteppingCarefully() ? SecurityUpgrade.removePlayer(stack, id) : SecurityUpgrade.addPlayer(stack, id, name);
            if (player.level().isClientSide) {
                player.playSound(res.isError() ? ModSounds.ERROR.get() : ModSounds.SUCCESS.get(), ((Double)ConfigHolder.client.sound.bleepVolume.get()).floatValue(), 1.0f);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)("modularrouters.chatText.security." + res.toString()), (Object[])new Object[]{name}), false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static enum Result {
        ADDED,
        REMOVED,
        FULL,
        ALREADY_ADDED,
        ERROR,
        NOT_PRESENT;


        boolean isError() {
            return this != ADDED && this != REMOVED;
        }
    }
}

