/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class ModuleTarget {
    public final GlobalPos gPos;
    public final Direction face;
    public final String blockTranslationKey;
    private BlockCapabilityCache<IItemHandler, Direction> itemCapCache;
    private BlockCapabilityCache<IFluidHandler, Direction> fluidCapCache;
    private BlockCapabilityCache<IEnergyStorage, Direction> energyCapCache;
    private final Map<BlockCapability<?, ?>, BlockCapabilityCache<?, ?>> capabilityCache = new IdentityHashMap();

    public ModuleTarget(GlobalPos gPos, Direction face, String blockTranslationKey) {
        this.gPos = gPos;
        this.face = face;
        this.blockTranslationKey = blockTranslationKey;
    }

    public ModuleTarget(GlobalPos gPos, Direction face) {
        this(gPos, face, "");
    }

    public ModuleTarget(GlobalPos gPos) {
        this(gPos, null);
    }

    public CompoundTag toNBT() {
        return (CompoundTag)Util.make((Object)new CompoundTag(), ext -> {
            ext.put("Pos", MiscUtil.serializeGlobalPos(this.gPos));
            ext.putByte("Face", (byte)this.face.get3DDataValue());
            ext.putString("InvName", this.blockTranslationKey);
        });
    }

    public static ModuleTarget fromNBT(CompoundTag nbt) {
        GlobalPos gPos = MiscUtil.deserializeGlobalPos(nbt.getCompound("Pos"));
        Direction face = Direction.from3DDataValue((int)nbt.getByte("Face"));
        return new ModuleTarget(gPos, face, nbt.getString("InvName"));
    }

    public boolean isSameWorld(@Nullable Level world) {
        return world != null && this.gPos.dimension() == world.dimension();
    }

    public boolean isSameWorld(ModuleTarget dst) {
        return this.gPos.dimension() == dst.gPos.dimension();
    }

    public boolean hasItemHandlerClientSide() {
        return ClientUtil.theClientLevel().getCapability(Capabilities.ItemHandler.BLOCK, this.gPos.pos(), (Object)this.face) != null;
    }

    public Optional<IItemHandler> getItemHandler() {
        if (this.itemCapCache == null) {
            ServerLevel level = MiscUtil.getWorldForGlobalPos(this.gPos);
            if (level == null) {
                return Optional.empty();
            }
            this.itemCapCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)level, (BlockPos)this.gPos.pos(), (Object)this.face);
        }
        return Optional.ofNullable((IItemHandler)this.itemCapCache.getCapability());
    }

    public Optional<IFluidHandler> getFluidHandler() {
        if (this.fluidCapCache == null) {
            ServerLevel level = MiscUtil.getWorldForGlobalPos(this.gPos);
            if (level == null) {
                return Optional.empty();
            }
            this.fluidCapCache = BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)level, (BlockPos)this.gPos.pos(), (Object)this.face);
        }
        return Optional.ofNullable((IFluidHandler)this.fluidCapCache.getCapability());
    }

    public Optional<IEnergyStorage> getEnergyHandler() {
        if (this.energyCapCache == null) {
            ServerLevel level = MiscUtil.getWorldForGlobalPos(this.gPos);
            if (level == null) {
                return Optional.empty();
            }
            this.energyCapCache = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)level, (BlockPos)this.gPos.pos(), (Object)this.face);
        }
        return Optional.ofNullable((IEnergyStorage)this.energyCapCache.getCapability());
    }

    @Nullable
    public <T, C> T getCapability(BlockCapability<T, C> capability, @Nullable C context) {
        BlockCapabilityCache cached = this.capabilityCache.get(capability);
        if (cached != null && Objects.equals(cached.context(), context)) {
            return (T)cached.getCapability();
        }
        ServerLevel level = MiscUtil.getWorldForGlobalPos(this.gPos);
        if (level == null) {
            return null;
        }
        cached = BlockCapabilityCache.create(capability, (ServerLevel)level, (BlockPos)this.gPos.pos(), context);
        this.capabilityCache.put(capability, cached);
        return (T)cached.getCapability();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleTarget)) {
            return false;
        }
        ModuleTarget that = (ModuleTarget)o;
        return this.gPos.equals((Object)that.gPos) && this.face == that.face;
    }

    public int hashCode() {
        return Objects.hash(this.gPos, this.face);
    }

    public String toString() {
        return MiscUtil.locToString(this.gPos) + " " + this.face;
    }

    public Component getTextComponent() {
        return Component.translatable((String)this.blockTranslationKey).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)(" @ " + this)).withStyle(ChatFormatting.AQUA));
    }
}

