/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.ModularRoutersTags;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.TranslatableEnum;
import me.desht.modularrouters.util.fake_player.RouterFakePlayer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.util.FakePlayer;

public class CompiledActivatorModule
extends CompiledModule {
    public static final String NBT_ACTION_TYPE = "ActionType2";
    public static final String NBT_LOOK_DIRECTION = "LookDirection";
    public static final String NBT_SNEAKING = "Sneaking";
    public static final String NBT_ENTITY_MODE = "EntityMode";
    private final ActionType actionType;
    private final LookDirection lookDirection;
    private final EntityMode entityMode;
    private final boolean sneaking;
    private int entityIdx;
    private final Set<String> BLOCK_METHODS = ImmutableSet.of((Object)"onBlockActivated", (Object)"use");
    private final Set<String> ITEM_METHODS = ImmutableSet.of((Object)"onItemUseFirst", (Object)"onItemUse", (Object)"useOn", (Object)"onItemRightClick", (Object)"use");
    private static final Set<Item> itemBlacklist = new HashSet<Item>();
    private static final Set<Block> blockBlacklist = new HashSet<Block>();

    public CompiledActivatorModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        CompoundTag compound = stack.getTagElement("modularrouters");
        if (compound != null) {
            this.actionType = ActionType.values()[compound.getInt(NBT_ACTION_TYPE)];
            this.lookDirection = LookDirection.values()[compound.getInt(NBT_LOOK_DIRECTION)];
            this.entityMode = EntityMode.values()[compound.getInt(NBT_ENTITY_MODE)];
            this.sneaking = compound.getBoolean(NBT_SNEAKING);
        } else {
            this.actionType = ActionType.ITEM_OR_BLOCK;
            this.lookDirection = LookDirection.LEVEL;
            this.entityMode = EntityMode.NEAREST;
            this.sneaking = false;
        }
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        boolean didWork;
        ItemStack stack = router.getBufferItemStack();
        if (itemBlacklist.contains(stack.getItem())) {
            return false;
        }
        if (!stack.isEmpty() && !this.getFilter().test(stack) || stack.isEmpty() && !this.getFilter().isEmpty() && !this.getFilter().isBlacklist()) {
            return false;
        }
        RouterFakePlayer fakePlayer = router.getFakePlayer();
        Vec3 centre = Vec3.atCenterOf((Vec3i)router.getBlockPos());
        fakePlayer.setPos(centre.x() + (double)this.getFacing().getStepX() * 0.501, centre.y() + (double)this.getFacing().getStepY() * 0.501, centre.z() + (double)this.getFacing().getStepZ() * 0.501);
        fakePlayer.setShiftKeyDown(this.sneaking);
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, stack);
        switch (this.actionType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ITEM_OR_BLOCK: {
                boolean bl = this.doUseItem(router, fakePlayer);
                break;
            }
            case USE_ITEM_ON_ENTITY: {
                boolean bl = this.doUseItemOnEntity(router, fakePlayer);
                break;
            }
            case ATTACK_ENTITY: {
                boolean bl = didWork = this.doAttackEntity(router, fakePlayer);
            }
        }
        if (didWork) {
            router.setBufferItemStack(fakePlayer.getMainHandItem());
            this.dropExtraItems(router, (Player)fakePlayer);
        }
        return didWork;
    }

    private boolean doUseItem(ModularRouterBlockEntity router, FakePlayer fakePlayer) {
        BlockPos pos = router.getBlockPos();
        Level world = Objects.requireNonNull(router.getLevel());
        ItemStack stack = router.getBufferItemStack();
        fakePlayer.setYRot((float)MiscUtil.getYawFromFacing(this.getFacing()));
        fakePlayer.setXRot(this.getFacing().getAxis() == Direction.Axis.Y ? (float)(this.getFacing().getStepY() * -90) : this.lookDirection.pitch);
        BlockHitResult hitResult = this.doRayTrace(pos, fakePlayer);
        BlockState state = world.getBlockState(hitResult.getBlockPos());
        if (hitResult.getType() != HitResult.Type.MISS && blockBlacklist.contains(state.getBlock())) {
            return false;
        }
        try {
            return fakePlayer.gameMode.useItemOn((ServerPlayer)fakePlayer, world, stack, InteractionHand.MAIN_HAND, hitResult).consumesAction() || fakePlayer.gameMode.useItem((ServerPlayer)fakePlayer, world, stack, InteractionHand.MAIN_HAND).consumesAction();
        }
        catch (Exception e) {
            this.handleBlacklisting(stack, state, e);
            return false;
        }
    }

    private void handleBlacklisting(ItemStack stack, BlockState state, Exception e) {
        for (StackTraceElement el : e.getStackTrace()) {
            if (this.ITEM_METHODS.contains(el.getMethodName())) {
                ModularRouters.LOGGER.error("Attempting to use item {} threw an exception. Blacklisting this item for the Activator Module until next server restart!", (Object)stack);
                ModularRouters.LOGGER.error("Stacktrace:", (Throwable)e);
                itemBlacklist.add(stack.getItem());
                return;
            }
            if (!this.BLOCK_METHODS.contains(el.getMethodName())) continue;
            ModularRouters.LOGGER.error("Attempting to use block {} threw an exception. Blacklisting this block for the Activator Module until next server restart!", (Object)state);
            ModularRouters.LOGGER.error("Stacktrace:", (Throwable)e);
            blockBlacklist.add(state.getBlock());
            return;
        }
    }

    private BlockHitResult doRayTrace(BlockPos routerPos, FakePlayer fp) {
        Vec3 fpVec = fp.position();
        int xOff = this.getFacing().getStepX();
        int yOff = this.getFacing().getStepY();
        int zOff = this.getFacing().getStepZ();
        BlockPos.MutableBlockPos targetPos = routerPos.relative(this.getFacing()).mutable();
        if (this.lookDirection != LookDirection.LEVEL && Block.isShapeFullBlock((VoxelShape)fp.level().getBlockState((BlockPos)targetPos).getShape((BlockGetter)fp.level(), (BlockPos)targetPos))) {
            if (this.lookDirection == LookDirection.ABOVE) {
                fpVec = Vec3.atCenterOf((Vec3i)targetPos).add(0.0, 1.0, 0.0);
                yOff = -1;
            } else if (this.lookDirection == LookDirection.BELOW) {
                fpVec = Vec3.atCenterOf((Vec3i)targetPos).add(0.0, -1.0, 0.0);
                yOff = 1;
            }
        } else if (this.lookDirection == LookDirection.ABOVE) {
            targetPos.move(Direction.UP);
            yOff = 1;
        } else if (this.lookDirection == LookDirection.BELOW) {
            targetPos.move(Direction.DOWN);
            yOff = -1;
        }
        double reachDist = Math.pow(this.getPlayerReachDistance((Player)fp), 2.0);
        while (targetPos.distSqr((Vec3i)routerPos) <= reachDist) {
            VoxelShape shape;
            if (!fp.level().isEmptyBlock((BlockPos)targetPos) && !(shape = fp.level().getBlockState((BlockPos)targetPos).getShape((BlockGetter)fp.level(), (BlockPos)targetPos)).isEmpty()) {
                Vec3 targetVec = ((AABB)shape.toAabbs().get(0)).getCenter().add(Vec3.atLowerCornerOf((Vec3i)targetPos));
                BlockHitResult res = fp.level().clip(new ClipContext(fpVec, targetVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.SOURCE_ONLY, (Entity)fp));
                if (res.getType() == HitResult.Type.BLOCK) {
                    return res;
                }
            }
            targetPos.move(xOff, yOff, zOff);
        }
        return BlockHitResult.miss((Vec3)fpVec.add(fp.getLookAngle()), (Direction)this.getFacing().getOpposite(), (BlockPos)routerPos.relative(this.getFacing()));
    }

    private double getPlayerReachDistance(Player player) {
        AttributeInstance attr;
        if (player != null && (attr = player.getAttribute((Attribute)NeoForgeMod.BLOCK_REACH.value())) != null) {
            return attr.getValue() + 1.0;
        }
        return 4.5;
    }

    private boolean doAttackEntity(ModularRouterBlockEntity router, RouterFakePlayer fakePlayer) {
        LivingEntity entity;
        block3: {
            block2: {
                entity = this.findEntity(router, LivingEntity.class, this::passesAttackBlacklist);
                if (entity == null) break block2;
                if (!(entity instanceof Player)) break block3;
                Player p = (Player)entity;
                if (router.getUpgradeCount((Item)ModItems.SECURITY_UPGRADE.get()) <= 0 || !router.isPermitted(p)) break block3;
            }
            return false;
        }
        fakePlayer.lookAt(EntityAnchorArgument.Anchor.EYES, entity.position());
        fakePlayer.attack((Entity)entity);
        return true;
    }

    private boolean doUseItemOnEntity(ModularRouterBlockEntity router, FakePlayer fakePlayer) {
        Entity entity = this.findEntity(router, Entity.class, this::passesUseBlacklist);
        if (entity == null) {
            return false;
        }
        InteractionResult result = fakePlayer.interactOn(entity, InteractionHand.MAIN_HAND);
        if (result.consumesAction()) {
            router.setBufferItemStack(fakePlayer.getMainHandItem());
            return true;
        }
        return false;
    }

    private <T extends Entity> T findEntity(ModularRouterBlockEntity router, Class<T> cls, Predicate<Entity> blacklistChecker) {
        Direction face = this.getFacing();
        BlockPos pos = router.getBlockPos();
        Vec3 vec = Vec3.atCenterOf((Vec3i)pos);
        AABB box = new AABB(vec, vec).move((double)face.getStepX() * 2.5, (double)face.getStepY() * 2.5, (double)face.getStepZ() * 2.5).inflate(2.0);
        List l = Objects.requireNonNull(router.getLevel()).getEntitiesOfClass(cls, box, blacklistChecker);
        if (l.isEmpty()) {
            return null;
        }
        switch (this.entityMode) {
            case RANDOM: {
                return (T)((Entity)l.get(router.getLevel().random.nextInt(l.size())));
            }
            case NEAREST: {
                l.sort(Comparator.comparingDouble(o -> o.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())));
                return (T)((Entity)l.get(0));
            }
            case ROUND_ROBIN: {
                l.sort(Comparator.comparingDouble(o -> o.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())));
                this.entityIdx = (this.entityIdx + 1) % l.size();
                return (T)((Entity)l.get(this.entityIdx));
            }
        }
        return null;
    }

    private boolean passesAttackBlacklist(Entity e) {
        return !e.getType().is(ModularRoutersTags.EntityTypes.activatorAttackBlacklist);
    }

    private boolean passesUseBlacklist(Entity e) {
        return !e.getType().is(ModularRoutersTags.EntityTypes.activatorInteractBlacklist);
    }

    private void dropExtraItems(ModularRouterBlockEntity router, Player fakePlayer) {
        NonNullList inv = fakePlayer.getInventory().items;
        Vec3 where = Vec3.atCenterOf((Vec3i)router.getBlockPos().relative(this.getFacing()));
        Level level = Objects.requireNonNull(router.getLevel());
        for (int i = 1; i < inv.size() && !((ItemStack)inv.get(i)).isEmpty(); ++i) {
            ItemEntity item = new ItemEntity(level, where.x(), where.y(), where.z(), (ItemStack)inv.get(i));
            router.getLevel().addFreshEntity((Entity)item);
            inv.set(i, (Object)ItemStack.EMPTY);
        }
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public LookDirection getLookDirection() {
        return this.lookDirection;
    }

    public EntityMode getEntityMode() {
        return this.entityMode;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public int getEnergyCost() {
        return this.actionType == ActionType.ATTACK_ENTITY ? (Integer)ConfigHolder.common.energyCosts.activatorModuleEnergyCostAttack.get() : (Integer)ConfigHolder.common.energyCosts.activatorModuleEnergyCost.get();
    }

    @Override
    public boolean careAboutItemAttributes() {
        return this.actionType == ActionType.ATTACK_ENTITY;
    }

    public static enum ActionType implements TranslatableEnum
    {
        ITEM_OR_BLOCK(false),
        USE_ITEM_ON_ENTITY(true),
        ATTACK_ENTITY(true);

        private final boolean entity;

        private ActionType(boolean entity) {
            this.entity = entity;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.itemText.activator.action." + this;
        }

        public boolean isEntityTarget() {
            return this.entity;
        }
    }

    public static enum LookDirection implements TranslatableEnum
    {
        LEVEL(0.0f),
        ABOVE(-45.0f),
        BELOW(45.0f);

        private final float pitch;

        private LookDirection(float pitch) {
            this.pitch = pitch;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.itemText.activator.direction." + this;
        }
    }

    public static enum EntityMode implements TranslatableEnum
    {
        NEAREST,
        RANDOM,
        ROUND_ROBIN;


        @Override
        public String getTranslationKey() {
            return "modularrouters.itemText.activator.entityMode." + this;
        }
    }
}

