/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.IPickaxeUser;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.ModuleHelper;
import me.desht.modularrouters.util.TranslatableEnum;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CompiledBreakerModule
extends CompiledModule {
    public static final String NBT_MATCH_TYPE = "MatchType";
    private final ItemStack pickaxe;
    private final MatchType matchType;

    public CompiledBreakerModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        this.pickaxe = ((IPickaxeUser)stack.getItem()).getPickaxe(stack);
        CompoundTag compound = ModuleHelper.validateNBT(stack);
        this.matchType = MatchType.values()[compound.getInt(NBT_MATCH_TYPE)];
        if (!EnchantmentHelper.getEnchantments((ItemStack)stack).isEmpty() && EnchantmentHelper.getEnchantments((ItemStack)this.pickaxe).isEmpty()) {
            EnchantmentHelper.setEnchantments((Map)EnchantmentHelper.getEnchantments((ItemStack)stack), (ItemStack)this.pickaxe);
        }
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        if (this.isRegulationOK(router, true)) {
            Level world = router.getLevel();
            if (!(world instanceof ServerLevel)) {
                return false;
            }
            BlockPos pos = this.getTarget().gPos.pos();
            BlockState oldState = world.getBlockState(pos);
            BlockUtil.BreakResult breakResult = BlockUtil.tryBreakBlock(router, world, pos, this.getFilter(), this.pickaxe, this.matchType == MatchType.BLOCK);
            if (breakResult.isBlockBroken()) {
                breakResult.processDrops(world, pos, router.getBuffer());
                if (((Boolean)ConfigHolder.common.module.breakerParticles.get()).booleanValue() && router.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) == 0) {
                    world.levelEvent(2001, pos, Block.getId((BlockState)oldState));
                }
                return true;
            }
        }
        return false;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public static enum MatchType implements TranslatableEnum
    {
        ITEM,
        BLOCK;


        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.label.breakMatchType." + this;
        }
    }
}

