/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.Extruder2ModuleMenu;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.compiled.CompiledExtruderModule1;
import me.desht.modularrouters.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.IFluidBlock;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class CompiledExtruderModule2
extends CompiledExtruderModule1 {
    private final List<ItemStack> blockList;
    private final boolean mimic;

    public CompiledExtruderModule2(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        ItemStack stack1;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        this.mimic = this.getAugmentCount((Item)ModItems.MIMIC_AUGMENT.get()) > 0;
        Extruder2ModuleMenu.TemplateHandler handler = new Extruder2ModuleMenu.TemplateHandler(stack, router);
        for (int i = 0; i < handler.getSlots() && stacks.size() < this.getRange() && !(stack1 = handler.getStackInSlot(i)).isEmpty(); ++i) {
            for (int j = 0; j < stack1.getCount() && stacks.size() < this.getRange(); ++j) {
                stacks.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack1, (int)1));
            }
        }
        this.blockList = ImmutableList.copyOf(stacks);
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        boolean extend = this.shouldExtend(router);
        Level world = router.nonNullLevel();
        if (extend && this.distance < this.blockList.size()) {
            if (!(this.blockList.get(this.distance).getItem() instanceof BlockItem)) {
                router.getExtensionData().putInt("ExtruderDist" + this.getFacing(), ++this.distance);
            } else {
                BlockPos placePos = router.getBlockPos().relative(this.getFacing(), this.distance + 1);
                BlockState state = ModBlocks.TEMPLATE_FRAME.get().defaultBlockState();
                if (BlockUtil.tryPlaceBlock(router, state, world, placePos)) {
                    world.getBlockEntity(placePos, ModBlockEntities.TEMPLATE_FRAME.get()).ifPresent(te -> {
                        te.setCamouflage(this.blockList.get(this.distance), this.getFacing(), this.getRouterFacing());
                        te.setExtendedMimic(this.mimic);
                        if (this.mimic) {
                            world.updateNeighborsAt(placePos, state.getBlock());
                        }
                    });
                    router.playSound(null, placePos, state.getBlock().getSoundType(state, (LevelReader)world, placePos, null).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                    router.getExtensionData().putInt("ExtruderDist" + this.getFacing(), ++this.distance);
                    this.tryPushEntities(router.getLevel(), placePos, this.getFacing());
                    return true;
                }
            }
        } else if (!extend && this.distance > 0) {
            BlockPos breakPos = router.getBlockPos().relative(this.getFacing(), this.distance);
            BlockState oldState = world.getBlockState(breakPos);
            router.getExtensionData().putInt("ExtruderDist" + this.getFacing(), --this.distance);
            if (this.okToBreak(oldState)) {
                if (oldState.getBlock() == ModBlocks.TEMPLATE_FRAME.get()) {
                    world.removeBlock(breakPos, false);
                }
                return true;
            }
        }
        return false;
    }

    private boolean okToBreak(BlockState state) {
        Block b = state.getBlock();
        return state.isAir() || b == ModBlocks.TEMPLATE_FRAME.get() || b instanceof IFluidBlock;
    }
}

