/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledDropperModule;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CompiledFlingerModule
extends CompiledDropperModule {
    public static final String NBT_SPEED = "Speed";
    public static final String NBT_PITCH = "Pitch";
    public static final String NBT_YAW = "Yaw";
    private final float speed;
    private final float pitch;
    private final float yaw;

    public CompiledFlingerModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        CompoundTag compound = ModuleHelper.validateNBT(stack);
        this.speed = compound.getFloat(NBT_SPEED);
        this.pitch = compound.getFloat(NBT_PITCH);
        this.yaw = compound.getFloat(NBT_YAW);
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        boolean fired = super.execute(router);
        if (fired && ((Boolean)ConfigHolder.common.module.flingerEffects.get()).booleanValue()) {
            Level level;
            ModuleTarget target = this.getTarget();
            int n = Math.round(this.speed * 5.0f);
            BlockPos pos = target.gPos.pos();
            if (router.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) < 2 && (level = router.getLevel()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, n, 0.0, 0.0, 0.0, 0.0);
            }
            router.playSound(null, pos, ModSounds.THUD.get(), SoundSource.BLOCKS, 0.5f + this.speed, 1.0f);
        }
        return fired;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getSpeed() {
        return this.speed;
    }

    @Override
    protected void setupItemVelocity(ModularRouterBlockEntity router, ItemEntity item) {
        Direction routerFacing = router.getAbsoluteFacing(ModuleItem.RelativeDirection.FRONT);
        float basePitch = 0.0f;
        double yawRad = Math.toRadians((switch (this.getDirection()) {
            case ModuleItem.RelativeDirection.UP -> {
                basePitch = 90.0f;
                yield this.yawFromFacing(routerFacing);
            }
            case ModuleItem.RelativeDirection.DOWN -> {
                basePitch = -90.0f;
                yield this.yawFromFacing(routerFacing);
            }
            default -> this.yawFromFacing(this.getFacing());
        }) + this.yaw);
        double pitchRad = Math.toRadians(basePitch + this.pitch);
        double x = Math.cos(yawRad) * Math.cos(pitchRad);
        double y = Math.sin(pitchRad);
        double z = -(Math.sin(yawRad) * Math.cos(pitchRad));
        item.setDeltaMovement(x * (double)this.speed, y * (double)this.speed, z * (double)this.speed);
    }

    private float yawFromFacing(Direction absoluteFacing) {
        return switch (absoluteFacing) {
            case Direction.EAST -> 0.0f;
            case Direction.NORTH -> 90.0f;
            case Direction.WEST -> 180.0f;
            case Direction.SOUTH -> 270.0f;
            default -> 0.0f;
        };
    }
}

