/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.FluidModule1;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class CompiledFluidModule1
extends CompiledModule {
    public static final String NBT_FORCE_EMPTY = "ForceEmpty";
    public static final String NBT_MAX_TRANSFER = "MaxTransfer";
    public static final String NBT_FLUID_DIRECTION = "FluidDir";
    public static final String NBT_REGULATE_ABSOLUTE = "RegulateAbsolute";
    public static final int BUCKET_VOLUME = 1000;
    private final int maxTransfer;
    private final FluidModule1.FluidDirection fluidDirection;
    private final boolean forceEmpty;
    private final boolean regulateAbsolute;

    public CompiledFluidModule1(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        CompoundTag compound = ModuleHelper.validateNBT(stack);
        this.maxTransfer = compound.getInt(NBT_MAX_TRANSFER);
        this.fluidDirection = FluidModule1.FluidDirection.values()[compound.getByte(NBT_FLUID_DIRECTION)];
        this.forceEmpty = compound.getBoolean(NBT_FORCE_EMPTY);
        this.regulateAbsolute = compound.getBoolean(NBT_REGULATE_ABSOLUTE);
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        boolean didWork;
        if (this.getTarget() == null) {
            return false;
        }
        IFluidHandlerItem routerHandler = router.getFluidHandler();
        if (routerHandler == null) {
            return false;
        }
        Level world = Objects.requireNonNull(router.getLevel());
        Optional<IFluidHandler> targetFluidHandler = this.getTarget().getFluidHandler();
        if (targetFluidHandler.isPresent()) {
            didWork = switch (this.fluidDirection) {
                default -> throw new IncompatibleClassChangeError();
                case FluidModule1.FluidDirection.IN -> targetFluidHandler.map(worldHandler -> this.doTransfer(router, (IFluidHandler)worldHandler, (IFluidHandler)routerHandler, FluidModule1.FluidDirection.IN)).orElse(false);
                case FluidModule1.FluidDirection.OUT -> targetFluidHandler.map(worldHandler -> this.doTransfer(router, (IFluidHandler)routerHandler, (IFluidHandler)worldHandler, FluidModule1.FluidDirection.OUT)).orElse(false);
            };
        } else {
            boolean playSound = router.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) == 0;
            BlockPos pos = this.getTarget().gPos.pos();
            switch (this.fluidDirection) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case IN: {
                    boolean bl = this.tryPickupFluid(router, (IFluidHandler)routerHandler, world, pos, playSound);
                    break;
                }
                case OUT: {
                    boolean bl = didWork = this.tryPourOutFluid(router, (IFluidHandler)routerHandler, world, pos, playSound);
                }
            }
        }
        if (didWork) {
            router.setBufferItemStack(routerHandler.getContainer());
        }
        return didWork;
    }

    private boolean tryPickupFluid(ModularRouterBlockEntity router, IFluidHandler routerHandler, Level world, BlockPos pos, boolean playSound) {
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof BucketPickup)) {
            return false;
        }
        BucketPickup bucketPickup = (BucketPickup)block;
        FluidState fluidState = state.getFluidState();
        Fluid fluid = fluidState.getType();
        if (fluid == Fluids.EMPTY || !fluid.isSource(fluidState) || !this.getFilter().testFluid(fluid)) {
            return false;
        }
        FluidTank tank = new FluidTank(1000);
        tank.setFluid(new FluidStack(fluid, 1000));
        FluidStack maybeSent = FluidUtil.tryFluidTransfer((IFluidHandler)routerHandler, (IFluidHandler)tank, (int)1000, (boolean)false);
        if (maybeSent.getAmount() != 1000) {
            return false;
        }
        bucketPickup.pickupBlock((Player)router.getFakePlayer(), (LevelAccessor)world, pos, state);
        FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)routerHandler, (IFluidHandler)tank, (int)1000, (boolean)true);
        if (!transferred.isEmpty() && playSound) {
            this.playFillSound(world, pos, fluid);
        }
        return !transferred.isEmpty();
    }

    private boolean tryPourOutFluid(ModularRouterBlockEntity router, IFluidHandler routerHandler, Level world, BlockPos pos, boolean playSound) {
        LiquidBlockContainer liq;
        if (!(this.forceEmpty || world.isEmptyBlock(pos) || world.getBlockState(pos).getBlock() instanceof LiquidBlockContainer)) {
            return false;
        }
        FluidStack toPlace = routerHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (toPlace.getAmount() < 1000) {
            return false;
        }
        Fluid fluid = toPlace.getFluid();
        if (!this.getFilter().testFluid(toPlace.getFluid())) {
            return false;
        }
        BlockState blockstate = world.getBlockState(pos);
        boolean isReplaceable = blockstate.canBeReplaced(fluid);
        Block block = blockstate.getBlock();
        if (world.isEmptyBlock(pos) || isReplaceable || block instanceof LiquidBlockContainer && (liq = (LiquidBlockContainer)block).canPlaceLiquid((Player)router.getFakePlayer(), (BlockGetter)world, pos, blockstate, toPlace.getFluid())) {
            if (world.dimensionType().ultraWarm() && fluid.is(FluidTags.WATER)) {
                this.playEvaporationEffects(world, pos, fluid);
            } else if (block instanceof LiquidBlockContainer) {
                FluidState still;
                LiquidBlockContainer liq2 = (LiquidBlockContainer)block;
                if (fluid instanceof FlowingFluid) {
                    FlowingFluid ff = (FlowingFluid)fluid;
                    v0 = ff.getSource(false);
                } else {
                    v0 = still = fluid.defaultFluidState();
                }
                if (liq2.placeLiquid((LevelAccessor)world, pos, blockstate, still) && playSound) {
                    this.playEmptySound(world, pos, fluid);
                }
            } else {
                if (playSound) {
                    this.playEmptySound(world, pos, fluid);
                }
                if (isReplaceable) {
                    world.destroyBlock(pos, true);
                }
                world.setBlock(pos, fluid.defaultFluidState().createLegacyBlock(), 11);
            }
        }
        routerHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        return true;
    }

    private void playEmptySound(Level world, BlockPos pos, Fluid fluid) {
        SoundEvent soundevent = fluid.getFluidType().getSound(SoundActions.BUCKET_EMPTY);
        if (soundevent != null) {
            world.playSound(null, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void playFillSound(Level world, BlockPos pos, Fluid fluid) {
        SoundEvent soundEvent = fluid.getFluidType().getSound(SoundActions.BUCKET_FILL);
        if (soundEvent != null) {
            world.playSound(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void playEvaporationEffects(Level world, BlockPos pos, Fluid fluid) {
        SoundEvent soundEvent = fluid.getFluidType().getSound(SoundActions.FLUID_VAPORIZE);
        if (soundEvent != null) {
            world.playSound(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        for (int l = 0; l < 8; ++l) {
            world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    private boolean doTransfer(ModularRouterBlockEntity router, IFluidHandler src, IFluidHandler dest, FluidModule1.FluidDirection direction) {
        int amount;
        FluidStack newStack;
        if (this.getRegulationAmount() > 0) {
            if (direction == FluidModule1.FluidDirection.IN && this.checkFluidInTank(src) <= this.getRegulationAmount()) {
                return false;
            }
            if (direction == FluidModule1.FluidDirection.OUT && this.checkFluidInTank(dest) >= this.getRegulationAmount()) {
                return false;
            }
        }
        if (!(newStack = FluidUtil.tryFluidTransfer((IFluidHandler)dest, (IFluidHandler)src, (int)(amount = Math.min(this.getMaxTransfer(), router.getCurrentFluidTransferAllowance(direction))), (boolean)false)).isEmpty() && this.getFilter().testFluid(newStack.getFluid()) && !(newStack = FluidUtil.tryFluidTransfer((IFluidHandler)dest, (IFluidHandler)src, (int)newStack.getAmount(), (boolean)true)).isEmpty()) {
            router.transferredFluid(newStack.getAmount(), direction);
            return true;
        }
        return false;
    }

    private int checkFluidInTank(IFluidHandler handler) {
        int total = 0;
        int max = 0;
        if (this.isRegulateAbsolute()) {
            for (int idx = 0; idx < handler.getTanks(); ++idx) {
                total += handler.getFluidInTank(idx).getAmount();
            }
            return total;
        }
        for (int idx = 0; idx < handler.getTanks(); ++idx) {
            max += handler.getTankCapacity(idx);
            total += handler.getFluidInTank(idx).getAmount();
        }
        return max == 0 ? 0 : total * 100 / max;
    }

    public FluidModule1.FluidDirection getFluidDirection() {
        return this.fluidDirection;
    }

    public int getMaxTransfer() {
        return this.maxTransfer == 0 ? 1000 : this.maxTransfer;
    }

    public boolean isForceEmpty() {
        return this.forceEmpty;
    }

    public boolean isRegulateAbsolute() {
        return this.regulateAbsolute;
    }
}

