/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.item.module.PlayerModule;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.TranslatableEnum;
import me.desht.modularrouters.util.WildcardedRLMatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerArmorInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerOffhandInvWrapper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class CompiledPlayerModule
extends CompiledModule {
    public static final String NBT_OPERATION = "Operation";
    public static final String NBT_SECTION = "Section";
    private final Operation operation;
    private final Section section;
    private final GameProfile playerProfile;
    private WeakReference<Player> playerRef;

    public CompiledPlayerModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        CompoundTag compound = stack.getTagElement("modularrouters");
        if (compound != null) {
            this.playerProfile = ((PlayerModule)stack.getItem()).getOwnerProfile(stack).orElse(null);
            this.operation = Operation.values()[compound.getInt(NBT_OPERATION)];
            this.section = Section.values()[compound.getInt(NBT_SECTION)];
            if (router != null && !router.nonNullLevel().isClientSide) {
                ServerPlayer player = this.playerProfile == null ? null : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(this.playerProfile.getId());
                this.playerRef = new WeakReference<ServerPlayer>(player);
            } else {
                this.playerRef = new WeakReference<Object>(null);
            }
        } else {
            this.operation = Operation.EXTRACT;
            this.section = Section.MAIN;
            this.playerProfile = null;
        }
    }

    @Override
    public boolean hasTarget() {
        return this.getPlayer() != null;
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        Player player = this.getPlayer();
        if (this.isDimensionBlacklisted(router, player)) {
            return false;
        }
        IItemHandler itemHandler = this.getHandler(player);
        if (itemHandler == null) {
            return false;
        }
        ItemStack bufferStack = router.getBufferItemStack();
        switch (this.operation) {
            case EXTRACT: {
                if (bufferStack.getCount() >= bufferStack.getMaxStackSize()) break;
                ItemStack taken = this.transferToRouter(itemHandler, null, router);
                return !taken.isEmpty();
            }
            case INSERT: {
                int sent;
                if (!this.getFilter().test(bufferStack)) break;
                if (this.getSection() == Section.ARMOR) {
                    return this.insertArmor(router, itemHandler, bufferStack);
                }
                int nToSend = this.getItemsPerTick(router);
                if (this.getRegulationAmount() > 0) {
                    int existing = InventoryUtils.countItems(bufferStack, itemHandler, this.getRegulationAmount(), !this.getFilter().getFlags().isIgnoreDamage());
                    if ((nToSend = Math.min(nToSend, this.getRegulationAmount() - existing)) <= 0) {
                        return false;
                    }
                }
                return (sent = InventoryUtils.transferItems(router.getBuffer(), itemHandler, 0, nToSend)) > 0;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private boolean isDimensionBlacklisted(ModularRouterBlockEntity router, Player player) {
        WildcardedRLMatcher matcher = ModularRouters.getDimensionBlacklist();
        return matcher.test(router.nonNullLevel().dimension().location()) || matcher.test(player.level().dimension().location());
    }

    private Player getPlayer() {
        return this.playerRef == null ? null : (Player)this.playerRef.get();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().getUUID().equals(this.getPlayerId())) {
            this.playerRef = new WeakReference<Player>(event.getEntity());
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().getUUID().equals(this.getPlayerId())) {
            this.playerRef = new WeakReference<Object>(null);
        }
    }

    @Override
    public void onCompiled(ModularRouterBlockEntity router) {
        super.onCompiled(router);
        if (!router.nonNullLevel().isClientSide) {
            NeoForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public void cleanup(ModularRouterBlockEntity router) {
        super.cleanup(router);
        if (!router.nonNullLevel().isClientSide) {
            NeoForge.EVENT_BUS.unregister((Object)this);
        }
    }

    public UUID getPlayerId() {
        return this.playerProfile == null ? null : this.playerProfile.getId();
    }

    public String getPlayerName() {
        return this.playerProfile == null ? null : this.playerProfile.getName();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Section getSection() {
        return this.section;
    }

    private boolean insertArmor(ModularRouterBlockEntity router, IItemHandler itemHandler, ItemStack armorStack) {
        int slot = this.getSlotForArmorItem(armorStack);
        if (slot >= 0 && itemHandler.getStackInSlot(slot).isEmpty()) {
            ItemStack extracted = router.getBuffer().extractItem(0, 1, false);
            if (extracted.isEmpty()) {
                return false;
            }
            ItemStack res = itemHandler.insertItem(slot, extracted, false);
            return res.isEmpty();
        }
        return false;
    }

    private int getSlotForArmorItem(ItemStack stack) {
        return switch (Mob.getEquipmentSlotForItem((ItemStack)stack)) {
            case EquipmentSlot.HEAD -> 3;
            case EquipmentSlot.CHEST -> 2;
            case EquipmentSlot.LEGS -> 1;
            case EquipmentSlot.FEET -> 0;
            default -> -1;
        };
    }

    private IItemHandler getHandler(Player player) {
        return switch (this.section) {
            default -> throw new IncompatibleClassChangeError();
            case Section.MAIN -> new PlayerMainInvWrapper(player.getInventory());
            case Section.MAIN_NO_HOTBAR -> new PlayerMainInvNoHotbarWrapper(player.getInventory());
            case Section.ARMOR -> new PlayerArmorInvWrapper(player.getInventory());
            case Section.OFFHAND -> new PlayerOffhandInvWrapper(player.getInventory());
            case Section.ENDER -> new InvWrapper((Container)player.getEnderChestInventory());
        };
    }

    public static enum Operation implements TranslatableEnum
    {
        EXTRACT,
        INSERT;


        public String getSymbol() {
            return this == INSERT ? "\u27f9" : "\u27f8";
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.label.playerOp." + this;
        }
    }

    public static enum Section implements TranslatableEnum
    {
        MAIN,
        MAIN_NO_HOTBAR,
        ARMOR,
        OFFHAND,
        ENDER;


        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.label.playerSect." + this;
        }
    }

    public static class PlayerMainInvNoHotbarWrapper
    extends RangedWrapper {
        PlayerMainInvNoHotbarWrapper(Inventory inv) {
            super((IItemHandlerModifiable)new InvWrapper((Container)inv), Inventory.getSelectionSize(), inv.items.size());
        }
    }
}

